/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartEmbeddedContent;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import com.jetbrains.lang.dart.resolve.ComponentNameScopeProcessor;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartStructureViewElement
extends PsiTreeElementBase<NavigatablePsiElement>
implements ItemPresentation,
StructureViewTreeElement {
    public DartStructureViewElement(@NotNull NavigatablePsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/structure/DartStructureViewElement", "<init>"));
        }
        super((PsiElement)element);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        NavigatablePsiElement element = (NavigatablePsiElement)this.getElement();
        ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        if (element instanceof DartFile || element instanceof DartEmbeddedContent) {
            THashSet componentNames = new THashSet();
            DartPsiCompositeElementImpl.processDeclarationsImpl((PsiElement)element, new ComponentNameScopeProcessor((Set<DartComponentName>)componentNames), ResolveState.initial(), null);
            for (DartComponentName componentName : componentNames) {
                PsiElement parent = componentName.getParent();
                if (!(parent instanceof DartComponent)) continue;
                result.add(new DartStructureViewElement((DartComponent)parent));
            }
        } else if (element instanceof DartClass) {
            for (DartComponent subNamedComponent : DartResolveUtil.getNamedSubComponents((DartClass)element)) {
                result.add(new DartStructureViewElement(subNamedComponent));
            }
        }
        Collections.sort(result, (o1, o2) -> {
            PsiElement element2;
            PsiElement element1;
            if (o1 instanceof DartStructureViewElement && o2 instanceof DartStructureViewElement && (element1 = ((DartStructureViewElement)((Object)o1)).getElement()) != null && (element2 = ((DartStructureViewElement)((Object)o2)).getElement()) != null) {
                return element1.getTextRange().getStartOffset() - element2.getTextRange().getStartOffset();
            }
            return 0;
        });
        ArrayList<StructureViewTreeElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/structure/DartStructureViewElement", "getChildrenBase"));
        }
        return arrayList;
    }

    @Nullable
    public String getPresentableText() {
        NavigatablePsiElement element = (NavigatablePsiElement)this.getElement();
        ItemPresentation presentation = element == null ? null : element.getPresentation();
        return presentation == null ? null : presentation.getPresentableText();
    }
}

