/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.structure;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.structure.DartStructureViewElement;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartFunctionTypeAlias;
import com.jetbrains.lang.dart.psi.DartGetterDeclaration;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartSetterDeclaration;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartStructureViewModel
extends StructureViewModelBase
implements StructureViewModel.ElementInfoProvider {
    private static final Sorter[] SORTERS = new Sorter[]{Sorter.ALPHA_SORTER};
    private static final Filter ourFieldsFilter = new Filter(){
        @NonNls
        public static final String ID = "SHOW_FIELDS";

        public boolean isVisible(TreeElement treeNode) {
            if (!(treeNode instanceof DartStructureViewElement)) {
                return true;
            }
            PsiElement element = ((DartStructureViewElement)treeNode).getElement();
            DartComponentType type = DartComponentType.typeOf(element);
            if (type == DartComponentType.FIELD || type == DartComponentType.VARIABLE) {
                return false;
            }
            return !(element instanceof DartComponent) || !((DartComponent)element).isGetter() && !((DartComponent)element).isGetter();
        }

        public boolean isReverted() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message((String)"action.structureview.show.fields", (Object[])new Object[0]), null, PlatformIcons.FIELD_ICON);
            if (actionPresentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel$1", "getPresentation"));
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel$1", "getName"));
            }
            return ID;
        }
    };

    public DartStructureViewModel(@NotNull PsiFile psiFile, @Nullable Editor editor) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel", "<init>"));
        }
        super(psiFile, editor, (StructureViewTreeElement)new DartStructureViewElement((NavigatablePsiElement)psiFile));
        this.withSuitableClasses(new Class[]{DartVarAccessDeclaration.class, DartFunctionDeclarationWithBodyOrNative.class, DartMethodDeclaration.class, DartFactoryConstructorDeclaration.class, DartNamedConstructorDeclaration.class, DartFunctionTypeAlias.class, DartGetterDeclaration.class, DartSetterDeclaration.class, DartEnumConstantDeclaration.class, DartClass.class});
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    @NotNull
    public Filter[] getFilters() {
        Filter[] filterArray = new Filter[]{ourFieldsFilter};
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel", "getFilters"));
        }
        return filterArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (SORTERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/structure/DartStructureViewModel", "getSorters"));
        }
        return SORTERS;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        Object value = element.getValue();
        return value instanceof DartComponent && !(value instanceof DartClass);
    }

    public boolean shouldEnterElement(Object element) {
        return element instanceof DartClass;
    }
}

