/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.surroundWith;

import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.ide.surroundWith.statement.DartWithDoWhileSurrounder;
import com.jetbrains.lang.dart.ide.surroundWith.statement.DartWithForSurrounder;
import com.jetbrains.lang.dart.ide.surroundWith.statement.DartWithIfElseSurrounder;
import com.jetbrains.lang.dart.ide.surroundWith.statement.DartWithIfSurrounder;
import com.jetbrains.lang.dart.ide.surroundWith.statement.DartWithTryCatchFinallySurrounder;
import com.jetbrains.lang.dart.ide.surroundWith.statement.DartWithTryCatchSurrounder;
import com.jetbrains.lang.dart.ide.surroundWith.statement.DartWithWhileSurrounder;
import com.jetbrains.lang.dart.util.DartRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class DartStatementsSurroundDescriptor
implements SurroundDescriptor {
    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement[] statements = DartRefactoringUtil.findStatementsInRange(file, startOffset, endOffset);
        if (statements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/surroundWith/DartStatementsSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (statements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/surroundWith/DartStatementsSurroundDescriptor", "getElementsToSurround"));
        }
        return statements;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        Surrounder[] surrounderArray = new Surrounder[]{new DartWithIfSurrounder(), new DartWithIfElseSurrounder(), new DartWithWhileSurrounder(), new DartWithDoWhileSurrounder(), new DartWithForSurrounder(), new DartWithTryCatchSurrounder(), new DartWithTryCatchFinallySurrounder()};
        if (surrounderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/surroundWith/DartStatementsSurroundDescriptor", "getSurrounders"));
        }
        return surrounderArray;
    }

    public boolean isExclusive() {
        return false;
    }
}

