/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.surroundWith.expression;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartWithExpressionSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/surroundWith/expression/DartWithExpressionSurrounder", "isApplicable"));
        }
        return elements.length == 1 && elements[0] instanceof DartExpression;
    }

    @Nullable
    protected DartExpression getSurroundedNode(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/surroundWith/expression/DartWithExpressionSurrounder", "getSurroundedNode"));
        }
        return DartElementGenerator.createExpressionFromText(element.getProject(), this.getTemplateText(element));
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/surroundWith/expression/DartWithExpressionSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/surroundWith/expression/DartWithExpressionSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/surroundWith/expression/DartWithExpressionSurrounder", "surroundElements"));
        }
        PsiElement source = elements[0];
        DartExpression parenthExprNode = this.getSurroundedNode(source);
        if (parenthExprNode == null) {
            throw new IncorrectOperationException("Can't create expression for: " + source.getText());
        }
        PsiElement replace = source.replace((PsiElement)parenthExprNode);
        int endOffset = replace.getTextRange().getEndOffset();
        return TextRange.create((int)endOffset, (int)endOffset);
    }

    protected abstract String getTemplateText(PsiElement var1);
}

