/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.surroundWith.statement;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartStatementSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/surroundWith/statement/DartStatementSurrounder", "isApplicable"));
        }
        return true;
    }

    @Nullable
    protected PsiElement createSurrounder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/surroundWith/statement/DartStatementSurrounder", "createSurrounder"));
        }
        return DartElementGenerator.createStatementFromText(project, this.getTemplateText());
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/surroundWith/statement/DartStatementSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/surroundWith/statement/DartStatementSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/lang/dart/ide/surroundWith/statement/DartStatementSurrounder", "surroundElements"));
        }
        PsiElement parent = elements[0].getParent();
        PsiElement surrounder = this.createSurrounder(project);
        if (surrounder == null) {
            throw new IncorrectOperationException("Can't surround statements!");
        }
        PsiElement elementToAdd = this.findElementToAdd(surrounder = parent.addBefore(surrounder, elements[0]));
        if (elementToAdd == null) {
            parent.deleteChildRange(surrounder, surrounder);
            throw new IncorrectOperationException("Can't surround statements!");
        }
        for (PsiElement element : elements) {
            ASTNode node = element.getNode();
            ASTNode copyNode = node.copyElement();
            parent.getNode().removeChild(node);
            elementToAdd.getNode().addChild(copyNode);
        }
        this.afterAdd(elementToAdd);
        int endOffset = this.cleanUpAndGetPlaceForCaret(surrounder);
        return TextRange.create((int)endOffset, (int)endOffset);
    }

    protected void afterAdd(PsiElement elementToAdd) {
        PsiElement newLineNode = PsiParserFacade.SERVICE.getInstance((Project)elementToAdd.getProject()).createWhiteSpaceFromText("\n");
        elementToAdd.add(newLineNode);
    }

    protected abstract String getTemplateText();

    @Nullable
    protected abstract PsiElement findElementToAdd(@NotNull PsiElement var1);

    protected abstract int cleanUpAndGetPlaceForCaret(@NotNull PsiElement var1);
}

