/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.template;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.highlight.DartSyntaxHighlighter;
import com.jetbrains.lang.dart.psi.IDartBlock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartTemplateContextType
extends TemplateContextType {
    protected DartTemplateContextType(@NotNull @NonNls String id, @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/lang/dart/ide/template/DartTemplateContextType", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/jetbrains/lang/dart/ide/template/DartTemplateContextType", "<init>"));
        }
        super(id, presentableName, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/template/DartTemplateContextType", "isInContext"));
        }
        if (file.getLanguage() instanceof DartLanguage) {
            PsiElement element = file.findElementAt(offset);
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    @Nullable
    public SyntaxHighlighter createHighlighter() {
        return new DartSyntaxHighlighter();
    }

    public static class Statement
    extends DartTemplateContextType {
        public Statement() {
            super("DART_STATEMENT", "Statement", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/template/DartTemplateContextType$Statement", "isInContext"));
            }
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{IDartBlock.class, PsiComment.class}) instanceof IDartBlock;
        }
    }

    public static class Generic
    extends DartTemplateContextType {
        public Generic() {
            super("DART", DartBundle.message("dart.language.id", new Object[0]), EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/template/DartTemplateContextType$Generic", "isInContext"));
            }
            return true;
        }
    }
}

