/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.template.macro.DartMacroBase;
import com.jetbrains.lang.dart.psi.DartClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartClassNameMacro
extends DartMacroBase {
    public String getName() {
        return "dartClassName";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/lang/dart/ide/template/macro/DartClassNameMacro", "calculateResult"));
        }
        String containingClassName = this.getContainingClassName(context.getPsiElementAtStartOffset());
        return containingClassName == null ? null : new TextResult(containingClassName);
    }

    @VisibleForTesting
    @Nullable
    public String getContainingClassName(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)element, DartClass.class);
        return dartClass == null ? null : dartClass.getName();
    }
}

