/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.template.macro.DartMacroBase;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartDefaultFormalNamedParameter;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartOptionalFormalParameters;
import com.jetbrains.lang.dart.psi.DartSetterDeclaration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartMethodParametersMacro
extends DartMacroBase {
    public String getName() {
        return "dartMethodParameters";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/lang/dart/ide/template/macro/DartMethodParametersMacro", "calculateResult"));
        }
        List<String> parameterNames = this.getContainingMethodParameterNames(context.getPsiElementAtStartOffset());
        if (parameterNames == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (String name : parameterNames) {
            result.add(new TextResult(name));
        }
        return new ListResult((List)result);
    }

    @Nullable
    @VisibleForTesting
    public List<String> getContainingMethodParameterNames(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        DartComponent parent = (DartComponent)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{DartSetterDeclaration.class, DartFunctionDeclarationWithBodyOrNative.class, DartFactoryConstructorDeclaration.class, DartNamedConstructorDeclaration.class, DartMethodDeclaration.class, DartFunctionDeclarationWithBody.class});
        if (parent == null) {
            return null;
        }
        DartFormalParameterList parameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)parent, DartFormalParameterList.class);
        if (parameterList == null) {
            return null;
        }
        ArrayList results = Lists.newArrayList();
        for (DartNormalFormalParameter parameter : parameterList.getNormalFormalParameterList()) {
            DartMethodParametersMacro.findAndAddName(results, parameter);
        }
        DartOptionalFormalParameters optionalFormalParameters = parameterList.getOptionalFormalParameters();
        if (optionalFormalParameters != null) {
            for (DartDefaultFormalNamedParameter parameter : optionalFormalParameters.getDefaultFormalNamedParameterList()) {
                DartMethodParametersMacro.findAndAddName(results, parameter.getNormalFormalParameter());
            }
        }
        return results;
    }

    private static void findAndAddName(@NotNull List<String> results, @NotNull DartNormalFormalParameter parameter) {
        String name;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/jetbrains/lang/dart/ide/template/macro/DartMethodParametersMacro", "findAndAddName"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/lang/dart/ide/template/macro/DartMethodParametersMacro", "findAndAddName"));
        }
        DartComponentName componentName = parameter.findComponentName();
        if (componentName != null && (name = componentName.getName()) != null) {
            results.add(name);
        }
    }
}

