/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.template.macro.DartMacroBase;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartGetterDeclaration;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartReturnType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartMethodReturnTypeMacro
extends DartMacroBase {
    public String getName() {
        return "dartReturnType";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/lang/dart/ide/template/macro/DartMethodReturnTypeMacro", "calculateResult"));
        }
        String returnType = this.getContainingFunctionReturnType(context.getPsiElementAtStartOffset());
        return returnType == null ? null : new TextResult(returnType);
    }

    @VisibleForTesting
    @Nullable
    public String getContainingFunctionReturnType(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        DartComponent parent = (DartComponent)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{DartGetterDeclaration.class, DartFunctionDeclarationWithBodyOrNative.class, DartMethodDeclaration.class, DartFunctionDeclarationWithBody.class});
        if (parent instanceof DartGetterDeclaration) {
            return DartMethodReturnTypeMacro.getReturnTypeString(((DartGetterDeclaration)parent).getReturnType());
        }
        if (parent instanceof DartMethodDeclaration) {
            return DartMethodReturnTypeMacro.getReturnTypeString(((DartMethodDeclaration)parent).getReturnType());
        }
        if (parent instanceof DartFunctionDeclarationWithBodyOrNative) {
            return DartMethodReturnTypeMacro.getReturnTypeString(((DartFunctionDeclarationWithBodyOrNative)parent).getReturnType());
        }
        if (parent instanceof DartFunctionDeclarationWithBody) {
            return DartMethodReturnTypeMacro.getReturnTypeString(((DartFunctionDeclarationWithBody)parent).getReturnType());
        }
        return null;
    }

    private static String getReturnTypeString(@Nullable DartReturnType returnType) {
        return returnType == null ? null : returnType.getText();
    }
}

