/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.injection;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.util.DartPsiImplUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartMultiHostInjector
implements MultiHostInjector {
    @Nullable
    private static final Language JS_REGEXP_LANG = Language.findLanguageByID((String)"JSRegexp");

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<DartStringLiteralExpression>> list = Collections.singletonList(DartStringLiteralExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "elementsToInjectIn"));
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "getLanguagesToInject"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "getLanguagesToInject"));
        }
        if (element instanceof DartStringLiteralExpression) {
            if (DartMultiHostInjector.isRegExp((DartStringLiteralExpression)element)) {
                DartMultiHostInjector.injectRegExp(registrar, (DartStringLiteralExpression)element);
            } else {
                DartMultiHostInjector.injectHtmlIfNeeded(registrar, (DartStringLiteralExpression)element);
            }
        }
    }

    private static boolean isRegExp(@NotNull DartStringLiteralExpression element) {
        PsiElement parent3;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "isRegExp"));
        }
        PsiElement parent1 = element.getParent();
        PsiElement parentParent2 = parent1 instanceof DartArgumentList && parent1.getFirstChild() == element ? parent1.getParent() : null;
        PsiElement psiElement = parent3 = parentParent2 instanceof DartArguments ? parentParent2.getParent() : null;
        if (parent3 instanceof DartNewExpression) {
            DartType type = ((DartNewExpression)parent3).getType();
            return type != null && "RegExp".equals(type.getText());
        }
        return false;
    }

    private static void injectRegExp(@NotNull MultiHostRegistrar registrar, @NotNull DartStringLiteralExpression element) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "injectRegExp"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "injectRegExp"));
        }
        if (JS_REGEXP_LANG == null) {
            return;
        }
        PsiElement child = element.getFirstChild();
        IElementType elementType = child.getNode().getElementType();
        if (elementType != DartTokenTypes.RAW_SINGLE_QUOTED_STRING || child.getNextSibling() != null) {
            return;
        }
        Pair<String, TextRange> textAndRange = DartPsiImplUtil.getUnquotedDartStringAndItsRange(child.getText());
        if (((String)textAndRange.first).isEmpty()) {
            return;
        }
        registrar.startInjecting(JS_REGEXP_LANG);
        registrar.addPlace(null, null, (PsiLanguageInjectionHost)element, (TextRange)textAndRange.second);
        registrar.doneInjecting();
    }

    private static void injectHtmlIfNeeded(@NotNull MultiHostRegistrar registrar, @NotNull DartStringLiteralExpression element) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "injectHtmlIfNeeded"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "injectHtmlIfNeeded"));
        }
        SmartList infos = new SmartList();
        StringBuilder textBuf = new StringBuilder();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType type = child.getNode().getElementType();
            if (type == DartTokenTypes.REGULAR_STRING_PART) {
                textBuf.append(child.getText());
                String suffix = null;
                PsiElement nextSibling = child.getNextSibling();
                if (nextSibling != null && nextSibling.getNode().getElementType() != DartTokenTypes.CLOSING_QUOTE) {
                    suffix = "placeholder";
                    textBuf.append(suffix);
                }
                infos.add(new HtmlPlaceInfo(TextRange.from((int)child.getStartOffsetInParent(), (int)child.getTextLength()), suffix));
                continue;
            }
            if (type != DartTokenTypes.RAW_SINGLE_QUOTED_STRING && type != DartTokenTypes.RAW_TRIPLE_QUOTED_STRING) continue;
            Pair<String, TextRange> stringAndRange = DartPsiImplUtil.getUnquotedDartStringAndItsRange(child.getText());
            String string = (String)stringAndRange.first;
            TextRange stringRange = (TextRange)stringAndRange.second;
            infos.add(new HtmlPlaceInfo(stringRange.shiftRight(child.getStartOffsetInParent()), null));
            textBuf.append(string);
        }
        if (textBuf.length() > 0 && DartMultiHostInjector.looksLikeHtml(textBuf.toString())) {
            registrar.startInjecting((Language)HTMLLanguage.INSTANCE);
            for (HtmlPlaceInfo info : infos) {
                registrar.addPlace(null, info.suffix, (PsiLanguageInjectionHost)element, info.range);
            }
            registrar.doneInjecting();
        }
    }

    private static boolean looksLikeHtml(@NotNull String text) {
        boolean hasTag;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/injection/DartMultiHostInjector", "looksLikeHtml"));
        }
        if (!text.trim().startsWith("<")) {
            return false;
        }
        int tagStart = text.indexOf(60);
        int length = text.length();
        boolean bl = hasTag = tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text.charAt(tagStart + 1)) || tagStart < length - 2 && text.charAt(tagStart + 1) == '/' && Character.isLetter(text.charAt(tagStart + 2)) || tagStart < length - 3 && text.charAt(tagStart + 1) == '!' && text.charAt(tagStart + 2) == '-' && text.charAt(tagStart + 3) == '-') && text.indexOf(62, tagStart) > 0;
        if (hasTag && Character.isLetter(text.charAt(tagStart + 1)) && !text.contains("/>") && !text.contains("</")) {
            return false;
        }
        return hasTag;
    }

    private static class HtmlPlaceInfo {
        @NotNull
        private final TextRange range;
        @Nullable
        private final String suffix;

        public HtmlPlaceInfo(@NotNull TextRange range, @Nullable String suffix) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/lang/dart/injection/DartMultiHostInjector$HtmlPlaceInfo", "<init>"));
            }
            this.range = range;
            this.suffix = suffix;
        }
    }
}

