/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.lexer._DartLexer;

public class DartLexer
extends MergingLexerAdapterBase {
    private static final MergeFunction MERGE_FUNCTION = new MergeFunction(){

        public IElementType merge(IElementType firstTokenType, Lexer originalLexer) {
            if (firstTokenType == DartTokenTypes.REGULAR_STRING_PART || firstTokenType == DartTokenTypesSets.WHITE_SPACE) {
                IElementType nextTokenType;
                while ((nextTokenType = originalLexer.getTokenType()) == firstTokenType) {
                    originalLexer.advance();
                }
                return firstTokenType;
            }
            if (firstTokenType == DartTokenTypesSets.MULTI_LINE_COMMENT_START || firstTokenType == DartTokenTypesSets.MULTI_LINE_DOC_COMMENT_START) {
                IElementType nextTokenType;
                while ((nextTokenType = originalLexer.getTokenType()) != null) {
                    originalLexer.advance();
                    if (nextTokenType == DartTokenTypesSets.MULTI_LINE_COMMENT_END) break;
                    assert (nextTokenType == DartTokenTypesSets.MULTI_LINE_COMMENT_BODY) : nextTokenType;
                }
                return firstTokenType == DartTokenTypesSets.MULTI_LINE_DOC_COMMENT_START ? DartTokenTypesSets.MULTI_LINE_DOC_COMMENT : DartTokenTypesSets.MULTI_LINE_COMMENT;
            }
            return firstTokenType;
        }
    };

    public DartLexer() {
        super((Lexer)DartLexer.createLexer());
    }

    private static FlexAdapter createLexer() {
        return new FlexAdapter((FlexLexer)new _DartLexer(){

            @Override
            public void reset(CharSequence buffer, int start, int end, int initialState) {
                super.reset(buffer, start, end, initialState);
                this.myLeftBraceCount = 0;
                this.myStateStack.clear();
            }
        });
    }

    public MergeFunction getMergeFunction() {
        return MERGE_FUNCTION;
    }
}

