/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartIconProvider
extends IconProvider {
    public static final Icon FOLDER_SYMLINK_ICON = LayeredIcon.create((Icon)AllIcons.Nodes.Folder, (Icon)AllIcons.Nodes.Symlink);
    public static final Icon EXCLUDED_FOLDER_SYMLINK_ICON = LayeredIcon.create((Icon)AllIcons.Modules.ExcludeRoot, (Icon)AllIcons.Nodes.Symlink);

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/projectView/DartIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            VirtualFile folder = ((PsiDirectory)element).getVirtualFile();
            if (DartIconProvider.isFolderNearPubspecYaml(folder, "build")) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
                return fileIndex.isExcluded(folder) ? AllIcons.Modules.ExcludedGeneratedRoot : AllIcons.Modules.GeneratedFolder;
            }
            if (DartIconProvider.isFolderNearPubspecYaml(folder, "web")) {
                return AllIcons.Nodes.WebFolder;
            }
            if (DartIconProvider.isFolderNearPubspecYaml(folder, "test")) {
                return AllIcons.Modules.TestSourceFolder;
            }
            if (DartIconProvider.isFolderNearPubspecYaml(folder, "tool")) {
                return AllIcons.Nodes.KeymapTools;
            }
            if (DartIconProvider.isFolderNearPubspecYaml(folder.getParent(), "packages")) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
                return fileIndex.isExcluded(folder) ? EXCLUDED_FOLDER_SYMLINK_ICON : FOLDER_SYMLINK_ICON;
            }
        }
        return null;
    }

    public static boolean isFolderNearPubspecYaml(@Nullable VirtualFile folder, @NotNull String folderName) {
        if (folderName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderName", "com/jetbrains/lang/dart/projectView/DartIconProvider", "isFolderNearPubspecYaml"));
        }
        if (folder != null && folder.isDirectory() && folder.isInLocalFileSystem() && folderName.equals(folder.getName())) {
            VirtualFile parentFolder = folder.getParent();
            VirtualFile pubspecYamlFile = parentFolder != null ? parentFolder.findChild("pubspec.yaml") : null;
            return pubspecYamlFile != null;
        }
        return false;
    }
}

