/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import org.jetbrains.annotations.NotNull;

public class DartNodeDecorator
implements ProjectViewNodeDecorator {
    public void decorate(@NotNull ProjectViewNode node, @NotNull PresentationData presentation) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/projectView/DartNodeDecorator", "decorate"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/jetbrains/lang/dart/projectView/DartNodeDecorator", "decorate"));
        }
        if (node instanceof PsiFileNode || node instanceof PsiDirectoryNode) {
            VirtualFile nodeFile = node.getVirtualFile();
            Project project = node.getProject();
            if (nodeFile != null && project != null && DartAnalysisServerService.getInstance(project).isFileWithErrors(nodeFile)) {
                presentation.setAttributesKey(CodeInsightColors.ERRORS_ATTRIBUTES);
            }
        }
    }

    public void decorate(@NotNull PackageDependenciesNode node, @NotNull ColoredTreeCellRenderer cellRenderer) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/projectView/DartNodeDecorator", "decorate"));
        }
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "com/jetbrains/lang/dart/projectView/DartNodeDecorator", "decorate"));
        }
    }
}

