/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.projectView.DartIconProvider;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parentNode, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        VirtualFile pubspecYamlFile;
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "modify"));
        }
        if (parentNode instanceof ExternalLibrariesNode) {
            List list = ContainerUtil.map(children, node -> {
                if (node instanceof NamedLibraryElementNode && ("Dart Packages".equals(node.getName()) || "Dart SDK".equals(node.getName()))) {
                    final boolean isSdkRoot = "Dart SDK".equals(node.getName());
                    return new NamedLibraryElementNode(node.getProject(), (NamedLibraryElement)((NamedLibraryElementNode)node).getValue(), settings){

                        public boolean canNavigate() {
                            return isSdkRoot;
                        }

                        public void navigate(boolean requestFocus) {
                            Project project = this.getProject();
                            if (project != null) {
                                DartConfigurable.openDartSettings(project);
                            }
                        }
                    };
                }
                return node;
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "modify"));
            }
            return list;
        }
        if (parentNode instanceof NamedLibraryElementNode && ("Dart Packages".equals(parentNode.getName()) || "Dart SDK".equals(parentNode.getName()))) {
            boolean isSdkRoot = "Dart SDK".equals(parentNode.getName());
            List list = ContainerUtil.map(children, node -> {
                VirtualFile dir;
                VirtualFile virtualFile = dir = node instanceof PsiDirectoryNode ? ((PsiDirectoryNode)node).getVirtualFile() : null;
                if (dir != null && dir.isInLocalFileSystem() && dir.isDirectory() && (isSdkRoot || "lib".equals(dir.getName()))) {
                    return new DartSdkOrLibraryRootNode(node.getProject(), (PsiDirectory)((PsiDirectoryNode)node).getValue(), settings);
                }
                return node;
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "modify"));
            }
            return list;
        }
        Project project = parentNode.getProject();
        VirtualFile packagesDir = parentNode instanceof PsiDirectoryNode && project != null ? ((PsiDirectoryNode)parentNode).getVirtualFile() : null;
        VirtualFile parentFolder = packagesDir != null && packagesDir.isDirectory() && "packages".equals(packagesDir.getName()) ? packagesDir.getParent() : null;
        VirtualFile virtualFile = pubspecYamlFile = parentFolder != null ? parentFolder.findChild("pubspec.yaml") : null;
        if (pubspecYamlFile != null && !pubspecYamlFile.isDirectory()) {
            ArrayList<AbstractTreeNode> modifiedChildren = new ArrayList<AbstractTreeNode>(children);
            DartUrlResolver resolver = DartUrlResolver.getInstance(project, pubspecYamlFile);
            resolver.processLivePackages((PairConsumer<String, VirtualFile>)((PairConsumer)(packageName, packageDir) -> {
                if (children == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "lambda$modify$2"));
                }
                VirtualFile folder = packagesDir.findChild(packageName);
                if (folder != null) {
                    AbstractTreeNode node = DartTreeStructureProvider.getFolderNode(children, folder);
                    if (node == null) {
                        modifiedChildren.add(new SymlinkToLivePackageNode(project, (String)packageName, (VirtualFile)packageDir));
                    } else {
                        node.getPresentation().setLocationString(DartTreeStructureProvider.getPackageLocationString(packageDir));
                    }
                }
            }));
            ArrayList<AbstractTreeNode> arrayList = modifiedChildren;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "modify"));
            }
            return arrayList;
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "modify"));
        }
        return collection;
    }

    @Nullable
    private static AbstractTreeNode getFolderNode(@NotNull Collection<AbstractTreeNode> nodes, @NotNull VirtualFile folder) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "getFolderNode"));
        }
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "getFolderNode"));
        }
        for (AbstractTreeNode node : nodes) {
            if (!(node instanceof PsiDirectoryNode) || !folder.equals(((PsiDirectoryNode)node).getVirtualFile())) continue;
            return node;
        }
        return null;
    }

    private static String getPackageLocationString(@NotNull VirtualFile packageDir) {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider", "getPackageLocationString"));
        }
        String path = packageDir.getPath();
        int lastSlashIndex = path.lastIndexOf("/");
        int prevSlashIndex = lastSlashIndex == -1 ? -1 : path.substring(0, lastSlashIndex).lastIndexOf("/");
        return FileUtil.toSystemDependentName((String)(prevSlashIndex < 0 ? path : path.substring(prevSlashIndex + 1)));
    }

    private static class DartSdkOrLibraryRootNode
    extends PsiDirectoryNode {
        public DartSdkOrLibraryRootNode(Project project, PsiDirectory value, ViewSettings settings) {
            super(project, value, settings);
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        protected void updateImpl(PresentationData data) {
            VirtualFile parentDir;
            super.updateImpl(data);
            VirtualFile dir = this.getVirtualFile();
            VirtualFile virtualFile = parentDir = dir == null ? null : dir.getParent();
            if (parentDir != null && parentDir.isInLocalFileSystem() && dir.isDirectory() && "lib".equals(dir.getName())) {
                data.setPresentableText(parentDir.getName());
            }
            data.setLocationString("");
        }
    }

    private static class SymlinkToLivePackageNode
    extends AbstractTreeNode<String> {
        @NotNull
        private final String mySymlinkPath;

        public SymlinkToLivePackageNode(@NotNull Project project, @NotNull String packageName, @NotNull VirtualFile packageDir) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider$SymlinkToLivePackageNode", "<init>"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider$SymlinkToLivePackageNode", "<init>"));
            }
            if (packageDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider$SymlinkToLivePackageNode", "<init>"));
            }
            super(project, (Object)packageName);
            this.myName = packageName;
            this.mySymlinkPath = DartTreeStructureProvider.getPackageLocationString(packageDir);
            this.setIcon(DartIconProvider.EXCLUDED_FOLDER_SYMLINK_ICON);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectView/DartTreeStructureProvider$SymlinkToLivePackageNode", "getChildren"));
            }
            return list;
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(this.getIcon());
            presentation.setPresentableText(this.myName);
            presentation.setLocationString(this.mySymlinkPath);
        }

        public int getWeight() {
            return 0;
        }
    }
}

