/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.projectWizard.DartProjectTemplate;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

class CmdLineAppTemplate
extends DartProjectTemplate {
    public CmdLineAppTemplate() {
        super(DartBundle.message("dart.commandline.app.title", new Object[0]), "");
    }

    @Override
    public Collection<VirtualFile> generateProject(@NotNull String sdkRoot, @NotNull Module module, @NotNull VirtualFile baseDir) throws IOException {
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/CmdLineAppTemplate", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/CmdLineAppTemplate", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/lang/dart/projectWizard/CmdLineAppTemplate", "generateProject"));
        }
        VirtualFile pubspecFile = baseDir.createChildData((Object)this, "pubspec.yaml");
        pubspecFile.setBinaryContent(("name: " + module.getName() + "\nversion: 0.0.1\ndescription: A sample command-line application\ndependencies:\n\ndev_dependencies:\n#  unittest: any\n").getBytes(Charset.forName("UTF-8")));
        VirtualFile binDir = VfsUtil.createDirectoryIfMissing((VirtualFile)baseDir, (String)"bin");
        VirtualFile mainFile = binDir.createChildData((Object)this, module.getName().toLowerCase(Locale.US) + ".dart");
        mainFile.setBinaryContent("void main() {\n  print('Hello, World!');\n}\n".getBytes(Charset.forName("UTF-8")));
        CmdLineAppTemplate.createCmdLineRunConfiguration(module, mainFile);
        return Arrays.asList(pubspecFile, mainFile);
    }
}

