/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.actions.DartPubGetAction;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.projectWizard.DartModuleWizardStep;
import com.jetbrains.lang.dart.projectWizard.DartProjectWizardData;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import icons.DartIcons;
import java.io.IOException;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartModuleBuilder
extends ModuleBuilder {
    private DartProjectWizardData myWizardData;

    public String getName() {
        return DartBundle.message("dart.title", new Object[0]);
    }

    public String getPresentableName() {
        return DartBundle.message("dart.title", new Object[0]);
    }

    public String getDescription() {
        return DartBundle.message("dart.project.description", new Object[0]);
    }

    public Icon getBigIcon() {
        return DartIcons.Dart_16;
    }

    public Icon getNodeIcon() {
        return DartIcons.Dart_16;
    }

    public ModuleType getModuleType() {
        return WebModuleType.getInstance();
    }

    public String getParentGroup() {
        return "Static Web";
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        DartModuleWizardStep step = new DartModuleWizardStep(context);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    void setWizardData(DartProjectWizardData wizardData) {
        this.myWizardData = wizardData;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        VirtualFile baseDir;
        ContentEntry contentEntry = this.doAddContentEntry(modifiableRootModel);
        VirtualFile virtualFile = baseDir = contentEntry == null ? null : contentEntry.getFile();
        if (baseDir != null) {
            DartModuleBuilder.setupProject(modifiableRootModel, baseDir, this.myWizardData);
        }
    }

    static void setupProject(@NotNull ModifiableRootModel modifiableRootModel, @NotNull VirtualFile baseDir, @NotNull DartProjectWizardData wizardData) {
        if (modifiableRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableRootModel", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "setupProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "setupProject"));
        }
        if (wizardData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardData", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "setupProject"));
        }
        String templateName = wizardData.myTemplate == null ? "Empty project" : wizardData.myTemplate.getName();
        UsageTrigger.trigger((String)("DartProjectWizard." + templateName));
        DartModuleBuilder.setupSdkAndDartium(modifiableRootModel, wizardData);
        if (wizardData.myTemplate != null) {
            try {
                Collection<VirtualFile> filesToOpen = wizardData.myTemplate.generateProject(wizardData.dartSdkPath, modifiableRootModel.getModule(), baseDir);
                if (!filesToOpen.isEmpty()) {
                    DartModuleBuilder.scheduleFilesOpeningAndPubGet(modifiableRootModel.getModule(), filesToOpen);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void setupSdkAndDartium(@NotNull ModifiableRootModel modifiableRootModel, @NotNull DartProjectWizardData wizardData) {
        if (modifiableRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableRootModel", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "setupSdkAndDartium"));
        }
        if (wizardData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardData", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "setupSdkAndDartium"));
        }
        if (DartSdkUtil.isDartSdkHome(wizardData.dartSdkPath)) {
            Project project = modifiableRootModel.getProject();
            DartSdkUtil.updateKnownSdkPaths(project, wizardData.dartSdkPath);
            LibraryTable.ModifiableModel libraryTableModifiableModel = ModifiableModelsProvider.SERVICE.getInstance().getLibraryTableModifiableModel(project);
            DartSdkLibUtil.ensureDartSdkConfigured(project, libraryTableModifiableModel, wizardData.dartSdkPath);
            if (libraryTableModifiableModel.isChanged()) {
                libraryTableModifiableModel.commit();
            } else {
                ModifiableModelsProvider.SERVICE.getInstance().disposeLibraryTableModifiableModel(libraryTableModifiableModel);
            }
            modifiableRootModel.addInvalidLibrary("Dart SDK", "project");
        }
        DartiumUtil.applyDartiumSettings(FileUtilRt.toSystemIndependentName((String)wizardData.dartiumPath), wizardData.dartiumSettings);
    }

    private static void scheduleFilesOpeningAndPubGet(@NotNull Module module, @NotNull Collection<VirtualFile> files) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "scheduleFilesOpeningAndPubGet"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "scheduleFilesOpeningAndPubGet"));
        }
        DartModuleBuilder.runWhenNonModalIfModuleNotDisposed(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "lambda$scheduleFilesOpeningAndPubGet$0"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "lambda$scheduleFilesOpeningAndPubGet$0"));
            }
            FileEditorManager manager = FileEditorManager.getInstance((Project)module.getProject());
            for (VirtualFile file : files) {
                AnAction pubGetAction;
                manager.openFile(file, true);
                if (!"pubspec.yaml".equals(file.getName()) || !((pubGetAction = ActionManager.getInstance().getAction("Dart.pub.get")) instanceof DartPubGetAction)) continue;
                ((DartPubGetAction)pubGetAction).performPubAction(module, file, false);
            }
        }, module);
    }

    static void runWhenNonModalIfModuleNotDisposed(@NotNull Runnable runnable, @NotNull Module module) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "runWhenNonModalIfModuleNotDisposed"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "runWhenNonModalIfModuleNotDisposed"));
        }
        if (module.getProject().isInitialized()) {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, module.getDisposed());
            return;
        }
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(() -> {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "lambda$runWhenNonModalIfModuleNotDisposed$2"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "lambda$runWhenNonModalIfModuleNotDisposed$2"));
            }
            if (ApplicationManager.getApplication().getCurrentModalityState() == ModalityState.NON_MODAL) {
                runnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL, o -> {
                    if (module == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartModuleBuilder", "lambda$null$1"));
                    }
                    return module.isDisposed();
                });
            }
        });
    }
}

