/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.WebProjectGenerator;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.projectWizard.DartGeneratorPeer;
import com.jetbrains.lang.dart.projectWizard.DartModuleBuilder;
import com.jetbrains.lang.dart.projectWizard.DartProjectWizardData;
import icons.DartIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DartProjectGenerator
extends WebProjectTemplate<DartProjectWizardData>
implements Comparable<DartProjectGenerator> {
    @NotNull
    public final String getName() {
        String string = DartBundle.message("dart.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "getName"));
        }
        return string;
    }

    @NotNull
    public final String getDescription() {
        String string = DartBundle.message("dart.project.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "getDescription"));
        }
        return string;
    }

    public Icon getIcon() {
        return DartIcons.Dart_16;
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<DartProjectWizardData> createPeer() {
        DartGeneratorPeer dartGeneratorPeer = new DartGeneratorPeer();
        if (dartGeneratorPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "createPeer"));
        }
        return dartGeneratorPeer;
    }

    public final void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull DartProjectWizardData data, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "generateProject"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "generateProject"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "lambda$generateProject$0"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "lambda$generateProject$0"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "lambda$generateProject$0"));
            }
            ModifiableRootModel modifiableModel = ModifiableModelsProvider.SERVICE.getInstance().getModuleModifiableModel(module);
            DartModuleBuilder.setupProject(modifiableModel, baseDir, data);
            ModifiableModelsProvider.SERVICE.getInstance().commitModuleModifiableModel(modifiableModel);
        });
    }

    @Override
    public int compareTo(@NotNull DartProjectGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/jetbrains/lang/dart/projectWizard/DartProjectGenerator", "compareTo"));
        }
        return this.getName().compareTo(generator.getName());
    }
}

