/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfigurationType;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunnerParameters;
import com.jetbrains.lang.dart.projectWizard.CmdLineAppTemplate;
import com.jetbrains.lang.dart.projectWizard.DartModuleBuilder;
import com.jetbrains.lang.dart.projectWizard.Stagehand;
import com.jetbrains.lang.dart.projectWizard.StagehandTemplate;
import com.jetbrains.lang.dart.projectWizard.WebAppTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DartProjectTemplate {
    private static final Stagehand STAGEHAND = new Stagehand();
    private static List<DartProjectTemplate> ourTemplateCache;
    private static final Logger LOG;
    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;

    public DartProjectTemplate(@NotNull String name, @NotNull String description) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "<init>"));
        }
        this.myName = name;
        this.myDescription = description;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "getDescription"));
        }
        return string;
    }

    public abstract Collection<VirtualFile> generateProject(@NotNull String var1, @NotNull Module var2, @NotNull VirtualFile var3) throws IOException;

    public static void loadTemplatesAsync(String sdkRoot, @NotNull Consumer<List<DartProjectTemplate>> templatesConsumer) {
        if (templatesConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templatesConsumer", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "loadTemplatesAsync"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("DartProjectTemplate.loadTemplatesAsync() must be called in pooled thread without read action");
        }
        ArrayList<DartProjectTemplate> templates = new ArrayList<DartProjectTemplate>();
        try {
            templates.addAll(DartProjectTemplate.getStagehandTemplates(sdkRoot));
        }
        finally {
            if (templates.isEmpty()) {
                templates.add(new WebAppTemplate());
                templates.add(new CmdLineAppTemplate());
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (templatesConsumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templatesConsumer", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "lambda$loadTemplatesAsync$0"));
                }
                templatesConsumer.consume((Object)templates);
            }, ModalityState.any());
        }
    }

    @NotNull
    private static List<DartProjectTemplate> getStagehandTemplates(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "getStagehandTemplates"));
        }
        if (ourTemplateCache != null) {
            List<DartProjectTemplate> list = ourTemplateCache;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "getStagehandTemplates"));
            }
            return list;
        }
        STAGEHAND.install(sdkRoot);
        List<Stagehand.StagehandDescriptor> templates = STAGEHAND.getAvailableTemplates(sdkRoot);
        ourTemplateCache = new ArrayList<DartProjectTemplate>();
        for (Stagehand.StagehandDescriptor template : templates) {
            ourTemplateCache.add(new StagehandTemplate(STAGEHAND, template));
        }
        List<DartProjectTemplate> list = ourTemplateCache;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "getStagehandTemplates"));
        }
        return list;
    }

    static void createWebRunConfiguration(@NotNull Module module, @NotNull VirtualFile htmlFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "createWebRunConfiguration"));
        }
        if (htmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlFile", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "createWebRunConfiguration"));
        }
        DartModuleBuilder.runWhenNonModalIfModuleNotDisposed(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "lambda$createWebRunConfiguration$1"));
            }
            if (htmlFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlFile", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "lambda$createWebRunConfiguration$1"));
            }
            WebBrowser dartium = DartiumUtil.getDartiumBrowser();
            if (dartium == null) {
                return;
            }
            Url url = WebBrowserServiceImpl.getDebuggableUrl((PsiElement)PsiManager.getInstance((Project)module.getProject()).findFile(htmlFile));
            if (url == null) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            try {
                RunnerAndConfigurationSettings settings = runManager.createRunConfiguration("", JavascriptDebugConfigurationType.getTypeInstance().getFactory());
                ((JavaScriptDebugConfiguration)settings.getConfiguration()).setUri(url.toDecodedForm());
                ((JavaScriptDebugConfiguration)settings.getConfiguration()).setEngineId(dartium.getId().toString());
                settings.setName(((JavaScriptDebugConfiguration)settings.getConfiguration()).suggestedName());
                runManager.addConfiguration(settings, false);
                runManager.setSelectedConfiguration(settings);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, module);
    }

    static void createCmdLineRunConfiguration(@NotNull Module module, @NotNull VirtualFile mainDartFile) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "createCmdLineRunConfiguration"));
        }
        if (mainDartFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainDartFile", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "createCmdLineRunConfiguration"));
        }
        DartModuleBuilder.runWhenNonModalIfModuleNotDisposed(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "lambda$createCmdLineRunConfiguration$2"));
            }
            if (mainDartFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainDartFile", "com/jetbrains/lang/dart/projectWizard/DartProjectTemplate", "lambda$createCmdLineRunConfiguration$2"));
            }
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            RunnerAndConfigurationSettings settings = runManager.createRunConfiguration("", DartCommandLineRunConfigurationType.getInstance().getConfigurationFactories()[0]);
            DartCommandLineRunConfiguration runConfiguration = (DartCommandLineRunConfiguration)settings.getConfiguration();
            runConfiguration.getRunnerParameters().setFilePath(mainDartFile.getPath());
            runConfiguration.getRunnerParameters().setWorkingDirectory(DartCommandLineRunnerParameters.suggestDartWorkingDir(module.getProject(), mainDartFile));
            settings.setName(runConfiguration.suggestedName());
            runManager.addConfiguration(settings, false);
            runManager.setSelectedConfiguration(settings);
        }, module);
    }

    static {
        LOG = Logger.getInstance((String)DartProjectTemplate.class.getName());
    }
}

