/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Stagehand {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.lang.dart.projectWizard.Stagehand");
    private static final List<StagehandDescriptor> EMPTY = new ArrayList<StagehandDescriptor>();

    public void generateInto(@NotNull String sdkRoot, @NotNull VirtualFile projectDirectory, @NotNull String templateId) throws StagehandException {
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/Stagehand", "generateInto"));
        }
        if (projectDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDirectory", "com/jetbrains/lang/dart/projectWizard/Stagehand", "generateInto"));
        }
        if (templateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateId", "com/jetbrains/lang/dart/projectWizard/Stagehand", "generateInto"));
        }
        ProcessOutput output = new PubRunner(projectDirectory).runSync(sdkRoot, 30, "global", "run", "stagehand", "--author", SystemProperties.getUserName(), templateId);
        if (output.getExitCode() != 0) {
            throw new StagehandException(output.getStderr());
        }
    }

    public List<StagehandDescriptor> getAvailableTemplates(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/Stagehand", "getAvailableTemplates"));
        }
        try {
            ProcessOutput output = new PubRunner().runSync(sdkRoot, 10, "global", "run", "stagehand", "--machine");
            int exitCode = output.getExitCode();
            if (exitCode != 0) {
                return EMPTY;
            }
            JSONArray arr = new JSONArray(output.getStdout());
            ArrayList<StagehandDescriptor> result = new ArrayList<StagehandDescriptor>();
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                result.add(new StagehandDescriptor(obj.getString("name"), obj.optString("label"), obj.getString("description"), obj.optString("entrypoint")));
            }
            return result;
        }
        catch (StagehandException e) {
            LOG.info((Throwable)e);
        }
        catch (JSONException e) {
            LOG.info((Throwable)e);
        }
        return EMPTY;
    }

    public void install(@NotNull String sdkRoot) {
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/Stagehand", "install"));
        }
        try {
            new PubRunner().runSync(sdkRoot, 60, "global", "activate", "stagehand");
        }
        catch (StagehandException e) {
            LOG.info((Throwable)e);
        }
    }

    private static final class PubRunner {
        private final String myWorkingDirectory;

        PubRunner() {
            this.myWorkingDirectory = null;
        }

        PubRunner(VirtualFile workingDirectory) {
            this.myWorkingDirectory = workingDirectory.getCanonicalPath();
        }

        ProcessOutput runSync(@NotNull String sdkRoot, int timeoutInSeconds, String ... pubParameters) throws StagehandException {
            if (sdkRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/Stagehand$PubRunner", "runSync"));
            }
            GeneralCommandLine command = new GeneralCommandLine().withWorkDirectory(this.myWorkingDirectory);
            File pubFile = new File(DartSdkUtil.getPubPath(sdkRoot));
            command.setExePath(pubFile.getPath());
            command.addParameters(pubParameters);
            try {
                return new CapturingProcessHandler(command).runProcess(timeoutInSeconds * 1000, false);
            }
            catch (ExecutionException e) {
                throw new StagehandException(e);
            }
        }
    }

    public static class StagehandException
    extends Exception {
        public StagehandException(String message) {
            super(message);
        }

        public StagehandException(Throwable t) {
            super(t);
        }
    }

    public static class StagehandDescriptor {
        public final String myId;
        public final String myLabel;
        public final String myDescription;
        public final String myEntrypoint;

        public StagehandDescriptor(String id, String label, String description, String entrypoint) {
            this.myId = id;
            this.myLabel = label;
            this.myDescription = description;
            this.myEntrypoint = entrypoint;
        }

        public String toString() {
            return StringUtil.join((String[])new String[]{"[", this.myId, ",", this.myLabel, ",", this.myDescription, ",", this.myEntrypoint, "]"});
        }
    }
}

