/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.projectWizard.DartProjectTemplate;
import com.jetbrains.lang.dart.projectWizard.Stagehand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class StagehandTemplate
extends DartProjectTemplate {
    @NotNull
    private final Stagehand myStagehand;
    @NotNull
    private final Stagehand.StagehandDescriptor myTemplate;

    public StagehandTemplate(@NotNull Stagehand stagehand, @NotNull Stagehand.StagehandDescriptor template) {
        if (stagehand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stagehand", "com/jetbrains/lang/dart/projectWizard/StagehandTemplate", "<init>"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/jetbrains/lang/dart/projectWizard/StagehandTemplate", "<init>"));
        }
        super(StagehandTemplate.getLabel(template), template.myDescription);
        this.myStagehand = stagehand;
        this.myTemplate = template;
    }

    private static String getLabel(Stagehand.StagehandDescriptor descriptor) {
        return !StringUtil.isEmptyOrSpaces((String)descriptor.myLabel) ? descriptor.myLabel : StagehandTemplate.prettify(descriptor.myId);
    }

    @Override
    public Collection<VirtualFile> generateProject(@NotNull String sdkRoot, @NotNull Module module, @NotNull VirtualFile baseDir) throws IOException {
        VirtualFile mainFile;
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/StagehandTemplate", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/StagehandTemplate", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/lang/dart/projectWizard/StagehandTemplate", "generateProject"));
        }
        try {
            this.myStagehand.generateInto(sdkRoot, baseDir, this.myTemplate.myId);
        }
        catch (Stagehand.StagehandException e) {
            throw new IOException(e);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        VirtualFile pubspec = LocalFileSystem.getInstance().refreshAndFindFileByPath(baseDir.getPath() + "/" + "pubspec.yaml");
        ContainerUtil.addIfNotNull(files, (Object)pubspec);
        VirtualFile virtualFile = mainFile = this.myTemplate.myEntrypoint.isEmpty() ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(baseDir.getPath() + "/" + this.myTemplate.myEntrypoint);
        if (mainFile != null && mainFile.getName().equals("index.html")) {
            ContainerUtil.addIfNotNull(files, (Object)mainFile.getParent().findChild("main.dart"));
        }
        ContainerUtil.addIfNotNull(files, mainFile);
        if (!this.myTemplate.myEntrypoint.isEmpty() && mainFile != null) {
            if (this.myTemplate.myEntrypoint.startsWith("bin/") && mainFile.getFileType() == DartFileType.INSTANCE) {
                StagehandTemplate.createCmdLineRunConfiguration(module, mainFile);
            }
            if (this.myTemplate.myEntrypoint.startsWith("web/") && mainFile.getFileType() == HtmlFileType.INSTANCE) {
                StagehandTemplate.createWebRunConfiguration(module, mainFile);
            }
        }
        return files;
    }

    private static String prettify(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/projectWizard/StagehandTemplate", "prettify"));
        }
        if ((name = StringUtil.capitalize((String)name)).endsWith("app")) {
            name = name.substring(0, name.length() - "app".length()) + " App";
        }
        return name;
    }
}

