/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.projectWizard;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.projectWizard.DartProjectTemplate;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

class WebAppTemplate
extends DartProjectTemplate {
    public WebAppTemplate() {
        super(DartBundle.message("dart.web.app.title", new Object[0]), "");
    }

    @Override
    public Collection<VirtualFile> generateProject(@NotNull String sdkRoot, @NotNull Module module, @NotNull VirtualFile baseDir) throws IOException {
        if (sdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkRoot", "com/jetbrains/lang/dart/projectWizard/WebAppTemplate", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/projectWizard/WebAppTemplate", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/lang/dart/projectWizard/WebAppTemplate", "generateProject"));
        }
        String projectTitle = StringUtil.toTitleCase((String)module.getName());
        String lowercaseName = module.getName().toLowerCase(Locale.US);
        VirtualFile pubspecFile = baseDir.createChildData((Object)this, "pubspec.yaml");
        pubspecFile.setBinaryContent(("name: " + module.getName() + "\nversion: 0.0.1\ndescription: A sample web application\ndependencies:\n  browser: any\ndev_dependencies:\n#  unittest: any\n").getBytes(Charset.forName("UTF-8")));
        VirtualFile webDir = VfsUtil.createDirectoryIfMissing((VirtualFile)baseDir, (String)"web");
        VirtualFile dartFile = webDir.createChildData((Object)this, lowercaseName + ".dart");
        dartFile.setBinaryContent("import 'dart:html';\n\nvoid main() {\n  querySelector('#sample_text_id')\n    ..text = 'Click me!'\n    ..onClick.listen(reverseText);\n}\n\nvoid reverseText(MouseEvent event) {\n  var text = querySelector('#sample_text_id').text;\n  var buffer = new StringBuffer();\n  for (int i = text.length - 1; i >= 0; i--) {\n    buffer.write(text[i]);\n  }\n  querySelector('#sample_text_id').text = buffer.toString();\n}\n".getBytes(Charset.forName("UTF-8")));
        VirtualFile htmlFile = webDir.createChildData((Object)this, lowercaseName + ".html");
        htmlFile.setBinaryContent(("<!DOCTYPE html>\n\n<html>\n  <head>\n    <meta charset=\"utf-8\">\n    <title>" + projectTitle + "</title>\n    <link rel=\"stylesheet\" href=\"" + lowercaseName + ".css\">\n  </head>\n  <body>\n    <h1>" + projectTitle + "</h1>\n\n    <p>Hello world from Dart!</p>\n\n    <div id=\"sample_container_id\">\n      <p id=\"sample_text_id\">Click me!</p>\n    </div>\n\n    <script type=\"" + "application/dart" + "\" src=\"" + lowercaseName + ".dart\"></script>\n    <script src=\"packages/browser/dart.js\"></script>\n  </body>\n</html>\n").getBytes(Charset.forName("UTF-8")));
        VirtualFile cssFile = webDir.createChildData((Object)this, lowercaseName + ".css");
        cssFile.setBinaryContent("body {\n  background-color: #F8F8F8;\n  font-family: 'Open Sans', sans-serif;\n  font-size: 14px;\n  font-weight: normal;\n  line-height: 1.2em;\n  margin: 15px;\n}\n\nh1, p {\n  color: #333;\n}\n\n#sample_container_id {\n  width: 100%;\n  height: 400px;\n  position: relative;\n  border: 1px solid #ccc;\n  background-color: #fff;\n}\n\n#sample_text_id {\n  font-size: 24pt;\n  text-align: center;\n  margin-top: 140px;\n  -webkit-user-select: none;\n  user-select: none;\n}\n".getBytes(Charset.forName("UTF-8")));
        WebAppTemplate.createWebRunConfiguration(module, htmlFile);
        return Arrays.asList(pubspecFile, htmlFile, cssFile, dartFile);
    }
}

