/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import gnu.trove.TObjectHashingStrategy;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartClassResolveCache {
    private final ConcurrentMap<DartClass, DartClassResolveResult> myMap;

    public static DartClassResolveCache getInstance(Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return (DartClassResolveCache)ServiceManager.getService((Project)project, DartClassResolveCache.class);
    }

    public DartClassResolveCache(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/jetbrains/lang/dart/psi/DartClassResolveCache", "<init>"));
        }
        this.myMap = DartClassResolveCache.createWeakMap();
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            public void beforePsiChanged(boolean isPhysical) {
                DartClassResolveCache.this.myMap.clear();
            }
        });
    }

    private static <K, V> ConcurrentMap<K, V> createWeakMap() {
        return ContainerUtil.createConcurrentWeakMap((int)7, (float)0.75f, (int)Runtime.getRuntime().availableProcessors(), (TObjectHashingStrategy)ContainerUtil.canonicalStrategy());
    }

    public void put(@NotNull DartClass dartClass, @NotNull DartClassResolveResult result) {
        if (dartClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartClass", "com/jetbrains/lang/dart/psi/DartClassResolveCache", "put"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/lang/dart/psi/DartClassResolveCache", "put"));
        }
        this.myMap.put(dartClass, result);
    }

    @Nullable
    public DartClassResolveResult get(DartClass dartClass) {
        return (DartClassResolveResult)this.myMap.get(dartClass);
    }
}

