/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.psi.DartExecutionScope;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import com.jetbrains.lang.dart.resolve.DartUseScope;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;

public class DartFile
extends PsiFileBase
implements DartExecutionScope {
    public DartFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/jetbrains/lang/dart/psi/DartFile", "<init>"));
        }
        super(viewProvider, DartLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = DartFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartFile", "getFileType"));
        }
        return languageFileType;
    }

    public String toString() {
        return "Dart File";
    }

    @NotNull
    public SearchScope getUseScope() {
        VirtualFile file = DartResolveUtil.getRealVirtualFile(this.getContainingFile());
        if (file == null || !ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(file)) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartFile", "getUseScope"));
            }
            return searchScope;
        }
        DartUseScope dartUseScope = new DartUseScope(this.getProject(), file);
        if (dartUseScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartFile", "getUseScope"));
        }
        return dartUseScope;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/psi/DartFile", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/lang/dart/psi/DartFile", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/lang/dart/psi/DartFile", "processDeclarations"));
        }
        return DartPsiCompositeElementImpl.processDeclarationsImpl((PsiElement)this, processor, state, lastParent) && super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public IElementType getTokenType() {
        return this.getNode().getElementType();
    }
}

