/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPackageAwareFileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        if ("dart" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "getId"));
        }
        return "dart";
    }

    public boolean acceptFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "acceptFile"));
        }
        return HtmlUtil.isHtmlFile((VirtualFile)file);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)StdFileTypes.HTML);
        fileTypeSink.consume((Object)StdFileTypes.XHTML);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(@NotNull FileContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "getIncludeInfos"));
        }
        if (PubspecYamlUtil.findPubspecYamlFile(content.getProject(), content.getFile()) == null) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        PsiFile psiFile = content.getPsiFile();
        FileIncludeInfo[] fileIncludeInfoArray = psiFile instanceof XmlFile ? DartPackageAwareFileIncludeProvider.getIncludeInfos((XmlFile)psiFile) : FileIncludeInfo.EMPTY;
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }

    private static FileIncludeInfo[] getIncludeInfos(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "getIncludeInfos"));
        }
        final ArrayList result = new ArrayList();
        xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                String path;
                String string = "link".equalsIgnoreCase(tag.getName()) ? DartPackageAwareFileIncludeProvider.getPathRelativeToPackageRoot(tag.getAttributeValue("href")) : (path = "script".equalsIgnoreCase(tag.getName()) ? DartPackageAwareFileIncludeProvider.getPathRelativeToPackageRoot(tag.getAttributeValue("src")) : null);
                if (!StringUtil.isEmptyOrSpaces((String)path)) {
                    result.add(new FileIncludeInfo(path));
                }
                super.visitXmlTag(tag);
            }

            public void visitElement(PsiElement element) {
                if (element.getLanguage() instanceof XMLLanguage) {
                    super.visitElement(element);
                }
            }
        });
        return (FileIncludeInfo[])ContainerUtil.toArray(result, (Object[])FileIncludeInfo.EMPTY);
    }

    @Nullable
    public PsiFileSystemItem resolveIncludedFile(@NotNull FileIncludeInfo info, @NotNull PsiFile context) {
        VirtualFile pubspecYamlFile;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "resolveIncludedFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/psi/DartPackageAwareFileIncludeProvider", "resolveIncludedFile"));
        }
        VirtualFile contextFile = DartResolveUtil.getRealVirtualFile(context);
        VirtualFile virtualFile = pubspecYamlFile = contextFile == null ? null : PubspecYamlUtil.findPubspecYamlFile(context.getProject(), contextFile);
        if (pubspecYamlFile == null) {
            return null;
        }
        VirtualFile targetFile = null;
        int slashIndex = info.path.indexOf(47);
        if (slashIndex > 0) {
            String packageName = info.path.substring(0, slashIndex);
            String relPath = info.path.substring(slashIndex + 1);
            DartUrlResolver urlResolver = DartUrlResolver.getInstance(context.getProject(), contextFile);
            VirtualFile packageDir = urlResolver.getPackageDirIfNotInOldStylePackagesFolder(packageName, relPath);
            if (packageDir != null) {
                targetFile = packageDir.findFileByRelativePath(relPath);
            }
        }
        if (targetFile == null) {
            targetFile = VfsUtilCore.findRelativeFile((String)("packages/" + info.path), (VirtualFile)pubspecYamlFile);
        }
        if (targetFile != null) {
            return targetFile.isDirectory() ? context.getManager().findDirectory(targetFile) : context.getManager().findFile(targetFile);
        }
        return null;
    }

    @Nullable
    private static String getPathRelativeToPackageRoot(@Nullable String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("packages/")) {
            return path.substring("packages".length() + 1);
        }
        int index = path.indexOf("/packages/");
        if (index > 0) {
            return path.substring(index + "packages".length() + 2);
        }
        return null;
    }
}

