/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class DartPackageAwareFileReference
extends FileReference {
    @NotNull
    private final DartUrlResolver myDartResolver;

    public DartPackageAwareFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text, @NotNull DartUrlResolver dartResolver) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "<init>"));
        }
        if (dartResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartResolver", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "<init>"));
        }
        super(fileReferenceSet, range, index, text);
        this.myDartResolver = dartResolver;
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "innerResolve"));
        }
        if ("packages".equals(this.getText())) {
            PsiDirectory psiDirectory;
            VirtualFile pubspecYamlFile = this.myDartResolver.getPubspecYamlFile();
            VirtualFile packagesDir = pubspecYamlFile == null ? null : pubspecYamlFile.getParent().findChild("packages");
            PsiDirectory psiDirectory2 = psiDirectory = packagesDir == null ? null : containingFile.getManager().findDirectory(packagesDir);
            if (psiDirectory != null) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)psiDirectory)};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "innerResolve"));
                }
                return resolveResultArray;
            }
        }
        int index = this.getIndex();
        FileReference[] allReferences = this.getFileReferenceSet().getAllReferences();
        if (index > 0 && "packages".equals(allReferences[index - 1].getText())) {
            PsiDirectory psiDirectory;
            StringBuilder b = new StringBuilder();
            for (int i = index + 1; i < allReferences.length; ++i) {
                if (b.length() > 0) {
                    b.append('/');
                }
                b.append(allReferences[i].getText());
            }
            VirtualFile packageDir = this.myDartResolver.getPackageDirIfNotInOldStylePackagesFolder(this.getText(), b.toString());
            PsiDirectory psiDirectory3 = psiDirectory = packageDir == null ? null : containingFile.getManager().findDirectory(packageDir);
            if (psiDirectory != null) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)psiDirectory)};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "innerResolve"));
                }
                return resolveResultArray;
            }
        }
        ResolveResult[] resolveResultArray = super.innerResolve(caseSensitive, containingFile);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "innerResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<String> result;
        Object[] superVariants = super.getVariants();
        if (this.getIndex() == 0) {
            PsiDirectory psiDirectory;
            VirtualFile pubspecYamlFile = this.myDartResolver.getPubspecYamlFile();
            VirtualFile packagesDir = pubspecYamlFile == null ? null : pubspecYamlFile.getParent().findChild("packages");
            PsiDirectory psiDirectory2 = psiDirectory = packagesDir == null ? null : this.getElement().getManager().findDirectory(packagesDir);
            if (psiDirectory != null) {
                Object[] objectArray = ArrayUtil.append((Object[])superVariants, (Object)psiDirectory);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "getVariants"));
                }
                return objectArray;
            }
        }
        if (this.getIndex() == 1 && "packages".equals(this.getFileReferenceSet().getReference(0).getText()) && !(result = new ArrayList<String>(this.myDartResolver.getLivePackageNames())).isEmpty()) {
            Collections.addAll(result, superVariants);
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "getVariants"));
            }
            return objectArray;
        }
        if (superVariants == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "getVariants"));
        }
        return superVariants;
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/DartPackageAwareFileReference", "bindToElement"));
        }
        String path = this.getFileReferenceSet().getPathString();
        if (path.startsWith("packages/") || path.contains("/packages/")) {
            DartUrlResolver urlResolver;
            String newUrl;
            VirtualFile contextFile = DartResolveUtil.getRealVirtualFile(this.getElement().getContainingFile());
            VirtualFile targetFile = DartResolveUtil.getRealVirtualFile(element.getContainingFile());
            if (contextFile != null && targetFile != null && (newUrl = (urlResolver = DartUrlResolver.getInstance(element.getProject(), contextFile)).getDartUrlForFile(targetFile)).startsWith("package:")) {
                int index = path.startsWith("packages/") ? 0 : path.indexOf("/packages/") + 1;
                String newName = path.substring(0, index) + "packages" + "/" + newUrl.substring("package:".length());
                return this.rename(newName);
            }
        }
        return super.bindToElement(element, absolute);
    }
}

