/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

public class PubspecYamlReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(YAMLKeyValue.class), (PsiReferenceProvider)new PubspecYamlReferenceProvider());
    }

    public static boolean isPathPackageDefinition(@NotNull YAMLKeyValue element) {
        String packageName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor", "isPathPackageDefinition"));
        }
        if (!"pubspec.yaml".equals(element.getContainingFile().getName())) {
            return false;
        }
        if (!"path".equals(element.getKeyText())) {
            return false;
        }
        PsiElement parent1 = element.getParent();
        PsiElement parent2 = parent1 instanceof YAMLMapping ? parent1.getParent() : null;
        String string = packageName = parent2 instanceof YAMLKeyValue ? ((YAMLKeyValue)parent2).getKeyText() : null;
        if (packageName == null) {
            return false;
        }
        PsiElement parent3 = parent2.getParent();
        PsiElement parent4 = parent3 instanceof YAMLMapping ? parent3.getParent() : null;
        return parent4 instanceof YAMLKeyValue && parent4.getParent() instanceof YAMLMapping && parent4.getParent().getParent() instanceof YAMLDocument && ("dependencies".equals(((YAMLKeyValue)parent4).getKeyText()) || "dev_dependencies".equals(((YAMLKeyValue)parent4).getKeyText()) || "dependency_overrides".equals(((YAMLKeyValue)parent4).getKeyText()));
    }

    private static class PubspecYamlReferenceProvider
    extends PsiReferenceProvider {
        private PubspecYamlReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor$PubspecYamlReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor$PubspecYamlReferenceProvider", "getReferencesByElement"));
            }
            if (!(element instanceof YAMLKeyValue) || !PubspecYamlReferenceContributor.isPathPackageDefinition((YAMLKeyValue)element)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor$PubspecYamlReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            YAMLValue value = ((YAMLKeyValue)element).getValue();
            if (value == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor$PubspecYamlReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String text = StringUtil.trimTrailing((String)FileUtil.toSystemIndependentName((String)value.getText()));
            boolean quoted = StringUtil.isQuotedString((String)text);
            int startInElement = value.getStartOffsetInParent() + (quoted ? 1 : 0);
            FileReferenceSet fileReferenceSet = new FileReferenceSet(StringUtil.unquoteString((String)text), element, startInElement, this, SystemInfo.isFileSystemCaseSensitive, false){

                @NotNull
                public Collection<PsiFileSystemItem> computeDefaultContexts() {
                    if (this.isAbsolutePathReference()) {
                        VirtualFile[] roots = ManagingFS.getInstance().getLocalRoots();
                        SmartList result = new SmartList();
                        for (VirtualFile root : roots) {
                            ContainerUtil.addIfNotNull((Collection)result, (Object)element.getManager().findDirectory(root));
                        }
                        SmartList smartList = result;
                        if (smartList == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor$PubspecYamlReferenceProvider$1", "computeDefaultContexts"));
                        }
                        return smartList;
                    }
                    Collection collection = super.computeDefaultContexts();
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor$PubspecYamlReferenceProvider$1", "computeDefaultContexts"));
                    }
                    return collection;
                }

                public boolean isAbsolutePathReference() {
                    String path = this.getPathString();
                    return SystemInfo.isWindows ? path.length() >= 3 && Character.isLetter(path.charAt(0)) && ':' == path.charAt(1) && '/' == path.charAt(2) : path.startsWith("/");
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return DIRECTORY_FILTER;
                }
            };
            FileReference[] fileReferenceArray = fileReferenceSet.getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/PubspecYamlReferenceContributor$PubspecYamlReferenceProvider", "getReferencesByElement"));
            }
            return fileReferenceArray;
        }
    }
}

