/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExecutionScope;
import com.jetbrains.lang.dart.psi.DartMetadata;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDartComponentImpl
extends DartPsiCompositeElementImpl
implements DartComponent {
    public AbstractDartComponentImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/psi/impl/AbstractDartComponentImpl", "<init>"));
        }
        super(node);
    }

    public String getName() {
        DartComponentName name = this.getComponentName();
        if (name != null) {
            return name.getText();
        }
        return super.getName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartComponentImpl", "setName"));
        }
        DartComponentName componentName = this.getComponentName();
        if (componentName != null) {
            componentName.setName(name);
        }
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getComponentName();
    }

    public Icon getIcon(int flags) {
        DartComponentType type = DartComponentType.typeOf((PsiElement)this);
        Icon icon = type == null ? super.getIcon(flags) : type.getIcon(this);
        icon = this.doOverlays(icon);
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(icon, 0);
        Icon visibility = this.isPublic() ? PlatformIcons.PUBLIC_ICON : PlatformIcons.PRIVATE_ICON;
        baseIcon.setIcon(visibility, 1);
        return baseIcon;
    }

    private Icon doOverlays(Icon icon) {
        if (this.isStatic() && !this.isGetter() && !this.isSetter()) {
            icon = AbstractDartComponentImpl.overlayIcons((Icon[])new Icon[]{icon, AllIcons.Nodes.StaticMark});
        }
        if (this.isFinal()) {
            icon = AbstractDartComponentImpl.overlayIcons((Icon[])new Icon[]{icon, AllIcons.Nodes.FinalMark});
        }
        if (this.isConst()) {
            icon = AbstractDartComponentImpl.overlayIcons((Icon[])new Icon[]{icon, AllIcons.Nodes.FinalMark});
        }
        return icon;
    }

    public boolean isConst() {
        return this.findChildByType(DartTokenTypes.CONST) != null;
    }

    @Override
    public boolean isFinal() {
        return this.findChildByType(DartTokenTypes.FINAL) != null;
    }

    @Override
    public boolean isOperator() {
        return this.findChildByType(DartTokenTypes.OPERATOR) != null;
    }

    @Override
    public boolean isStatic() {
        if (this instanceof DartVarDeclarationListPart) {
            return ((DartVarDeclarationList)this.getParent()).getVarAccessDeclaration().isStatic();
        }
        return this.findChildByType(DartTokenTypes.STATIC) != null;
    }

    @Override
    public boolean isPublic() {
        String name = this.getName();
        return name != null && !name.startsWith("_");
    }

    @Override
    public boolean isConstructor() {
        return DartComponentType.typeOf((PsiElement)this) == DartComponentType.CONSTRUCTOR;
    }

    @Override
    public boolean isSetter() {
        return this.findChildByType(DartTokenTypes.SET) != null;
    }

    @Override
    public boolean isGetter() {
        return this.findChildByType(DartTokenTypes.GET) != null;
    }

    @Override
    public boolean isAbstract() {
        DartComponentType componentType = DartComponentType.typeOf((PsiElement)this);
        return componentType == DartComponentType.CLASS && this.findChildByType(DartTokenTypes.ABSTRACT) != null || componentType == DartComponentType.METHOD && this.findChildByType(DartTokenTypes.EXTERNAL) == null && this.findChildByType(DartTokenTypes.FUNCTION_BODY) == null;
    }

    @Override
    public boolean isUnitMember() {
        return PsiTreeUtil.getParentOfType((PsiElement)this, DartComponent.class) == null;
    }

    @Override
    @Nullable
    public DartMetadata getMetadataByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartComponentImpl", "getMetadataByName"));
        }
        for (DartMetadata metadata : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, DartMetadata.class)) {
            if (!name.equals(metadata.getReferenceExpression().getText())) continue;
            return metadata;
        }
        return null;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                StringBuilder result = new StringBuilder();
                result.append(this.getComponentName());
                DartComponentType type = DartComponentType.typeOf((PsiElement)AbstractDartComponentImpl.this);
                if (!(type != DartComponentType.METHOD && type != DartComponentType.FUNCTION && type != DartComponentType.CONSTRUCTOR && type != DartComponentType.OPERATOR || AbstractDartComponentImpl.this.isGetter() || AbstractDartComponentImpl.this.isSetter())) {
                    String parameterList = DartPresentableUtil.getPresentableParameterList(AbstractDartComponentImpl.this);
                    result.append("(").append(parameterList).append(")");
                }
                if (type == DartComponentType.METHOD || type == DartComponentType.FIELD || type == DartComponentType.FUNCTION || type == DartComponentType.OPERATOR) {
                    DartReturnType returnType = (DartReturnType)PsiTreeUtil.getChildOfType((PsiElement)AbstractDartComponentImpl.this, DartReturnType.class);
                    DartType dartType = (DartType)PsiTreeUtil.getChildOfType((PsiElement)AbstractDartComponentImpl.this, DartType.class);
                    if (returnType != null) {
                        result.append(" ").append(DartPresentableUtil.RIGHT_ARROW).append(" ");
                        result.append(DartPresentableUtil.buildTypeText((DartComponent)AbstractDartComponentImpl.this, returnType, null));
                    } else if (dartType != null) {
                        result.append(" ").append(DartPresentableUtil.RIGHT_ARROW).append(" ");
                        result.append(DartPresentableUtil.buildTypeText((DartComponent)AbstractDartComponentImpl.this, dartType, null));
                    }
                }
                return result.toString();
            }

            @Nullable
            private String getComponentName() {
                String name = AbstractDartComponentImpl.this.getName();
                if (DartComponentType.typeOf((PsiElement)AbstractDartComponentImpl.this) == DartComponentType.CONSTRUCTOR) {
                    DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)AbstractDartComponentImpl.this, DartClass.class);
                    if (dartClass == null) {
                        return name;
                    }
                    return StringUtil.isEmpty((String)name) ? dartClass.getName() : dartClass.getName() + "." + name;
                }
                return name;
            }

            public String getLocationString() {
                DartClass dartClass;
                if (!AbstractDartComponentImpl.this.isValid()) {
                    return "";
                }
                if (!(AbstractDartComponentImpl.this instanceof DartClass) && (dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)AbstractDartComponentImpl.this, DartClass.class)) != null) {
                    return dartClass.getName();
                }
                DartExecutionScope root = (DartExecutionScope)PsiTreeUtil.getTopmostParentOfType((PsiElement)AbstractDartComponentImpl.this, DartExecutionScope.class);
                DartPartOfStatement partOfStatement = (DartPartOfStatement)PsiTreeUtil.getChildOfType((PsiElement)root, DartPartOfStatement.class);
                return partOfStatement == null ? null : partOfStatement.getLibraryName();
            }

            public Icon getIcon(boolean open) {
                return AbstractDartComponentImpl.this.getIcon(0);
            }
        };
    }

    public int getTextOffset() {
        DartComponentName name = this.getComponentName();
        return name != null ? name.getTextOffset() : super.getTextOffset();
    }
}

