/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartEnumDefinition;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartInterfaces;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartMixinApplication;
import com.jetbrains.lang.dart.psi.DartMixins;
import com.jetbrains.lang.dart.psi.DartSuperclass;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeParameters;
import com.jetbrains.lang.dart.psi.impl.AbstractDartComponentImpl;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDartPsiClass
extends AbstractDartComponentImpl
implements DartClass {
    private CachedValue<Map<String, List<DartComponent>>> myMembersCache;

    public AbstractDartPsiClass(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "<init>"));
        }
        super(node);
    }

    @Override
    public boolean isEnum() {
        return this instanceof DartEnumDefinition;
    }

    @Override
    @NotNull
    public List<DartEnumConstantDeclaration> getEnumConstantDeclarationList() {
        List<DartEnumConstantDeclaration> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getEnumConstantDeclarationList"));
        }
        return list;
    }

    @Override
    @Nullable
    public DartTypeParameters getTypeParameters() {
        return null;
    }

    @Override
    @NotNull
    public DartClassResolveResult getSuperClassResolvedOrObjectClass() {
        if ("Object".equals(this.getName())) {
            DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getSuperClassResolvedOrObjectClass"));
            }
            return dartClassResolveResult;
        }
        DartType superClass = this.getSuperClass();
        DartClassResolveResult dartClassResolveResult = superClass != null ? DartResolveUtil.resolveClassByType(superClass) : DartResolveUtil.findCoreClass((PsiElement)this, "Object");
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getSuperClassResolvedOrObjectClass"));
        }
        return dartClassResolveResult;
    }

    @Override
    @Nullable
    public DartType getSuperClass() {
        DartSuperclass superclass = (DartSuperclass)PsiTreeUtil.getChildOfType((PsiElement)this, DartSuperclass.class);
        if (superclass != null) {
            return superclass.getType();
        }
        DartMixinApplication mixinApp = (DartMixinApplication)PsiTreeUtil.getChildOfType((PsiElement)this, DartMixinApplication.class);
        if (mixinApp != null) {
            return mixinApp.getType();
        }
        return null;
    }

    @Override
    @NotNull
    public List<DartType> getImplementsList() {
        DartInterfaces interfaces;
        DartMixinApplication mixinApp = (DartMixinApplication)PsiTreeUtil.getChildOfType((PsiElement)this, DartMixinApplication.class);
        DartInterfaces dartInterfaces = interfaces = mixinApp != null ? mixinApp.getInterfaces() : (DartInterfaces)PsiTreeUtil.getChildOfType((PsiElement)this, DartInterfaces.class);
        if (interfaces != null) {
            List<DartType> list = DartResolveUtil.getTypes(interfaces.getTypeList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getImplementsList"));
            }
            return list;
        }
        List<DartType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getImplementsList"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<DartType> getMixinsList() {
        DartMixinApplication mixinApp = (DartMixinApplication)PsiTreeUtil.getChildOfType((PsiElement)this, DartMixinApplication.class);
        DartMixins mixins = (DartMixins)PsiTreeUtil.getChildOfType((PsiElement)(mixinApp != null ? mixinApp : this), DartMixins.class);
        if (mixins != null) {
            List<DartType> list = DartResolveUtil.getTypes(mixins.getTypeList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getMixinsList"));
            }
            return list;
        }
        List<DartType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getMixinsList"));
        }
        return list;
    }

    @Override
    public boolean isGeneric() {
        return this.getTypeParameters() != null;
    }

    @Override
    @NotNull
    public List<DartComponent> getMethods() {
        List<DartComponent> components = DartResolveUtil.findNamedSubComponents(this);
        List<DartComponent> list = DartResolveUtil.filterComponentsByType(components, DartComponentType.METHOD);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getMethods"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<DartComponent> getFields() {
        List<DartComponent> components = DartResolveUtil.findNamedSubComponents(this);
        List<DartComponent> list = DartResolveUtil.filterComponentsByType(components, DartComponentType.FIELD);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getFields"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<DartComponent> getConstructors() {
        List<DartComponent> components = DartResolveUtil.getNamedSubComponents(this);
        String className = this.getName();
        if (className == null) {
            List<DartComponent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getConstructors"));
            }
            return list;
        }
        List list = ContainerUtil.filter(components, component -> DartComponentType.typeOf((PsiElement)component) == DartComponentType.CONSTRUCTOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "getConstructors"));
        }
        return list;
    }

    @Override
    public List<DartMethodDeclaration> getOperators() {
        return DartResolveUtil.findOperators(this);
    }

    @Override
    @Nullable
    public DartMethodDeclaration findOperator(final String operator, final @Nullable DartClass rightDartClass) {
        return (DartMethodDeclaration)ContainerUtil.find(this.getOperators(), (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                DartMethodDeclaration method;
                if (element instanceof DartMethodDeclaration && (method = (DartMethodDeclaration)element).isOperator() && operator.equals(method.getName())) {
                    if (rightDartClass == null) {
                        return true;
                    }
                    DartFormalParameterList formalParameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)element, DartFormalParameterList.class);
                    return DartResolveUtil.checkParametersType(formalParameterList, rightDartClass);
                }
                return false;
            }
        });
    }

    @Override
    public DartComponent findFieldByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "findFieldByName"));
        }
        return (DartComponent)ContainerUtil.find(this.getFields(), component -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "lambda$findFieldByName$1"));
            }
            return name.equals(component.getName());
        });
    }

    @Override
    public DartComponent findMethodByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "findMethodByName"));
        }
        return (DartComponent)ContainerUtil.find(this.getMethods(), component -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "lambda$findMethodByName$2"));
            }
            return name.equals(component.getName());
        });
    }

    @Override
    public DartComponent findMemberByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "findMemberByName"));
        }
        List<DartComponent> membersByName = this.findMembersByName(name);
        return membersByName.isEmpty() ? null : membersByName.iterator().next();
    }

    @Override
    @NotNull
    public List<DartComponent> findMembersByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "findMembersByName"));
        }
        this.ensureMembersCacheInitialized();
        List components = (List)((Map)this.myMembersCache.getValue()).get(name);
        List list = components == null ? Collections.emptyList() : components;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/AbstractDartPsiClass", "findMembersByName"));
        }
        return list;
    }

    private void ensureMembersCacheInitialized() {
        if (this.myMembersCache == null) {
            this.myMembersCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                THashMap nameToMembers = new THashMap();
                for (DartComponent component : DartResolveUtil.findNamedSubComponents(false, this)) {
                    String dartClassName;
                    String componentName = component.getName();
                    DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)component, DartClass.class);
                    String string = dartClassName = dartClass != null ? dartClass.getName() : null;
                    if (dartClassName != null && dartClassName.equals(componentName)) continue;
                    List components = (List)nameToMembers.get(componentName);
                    if (components == null) {
                        components = new SmartList();
                        nameToMembers.put(componentName, components);
                    }
                    components.add(component);
                }
                return new CachedValueProvider.Result((Object)nameToMembers, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
        }
    }

    @Override
    public DartComponent findNamedConstructor(String name) {
        return (DartComponent)ContainerUtil.find(this.getConstructors(), component -> name.equals(component.getName()));
    }
}

