/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.psi.DartArrayAccessExpression;
import com.jetbrains.lang.dart.psi.DartAsExpression;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartListLiteralExpression;
import com.jetbrains.lang.dart.psi.DartMapLiteralExpression;
import com.jetbrains.lang.dart.psi.DartParenthesizedExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.impl.DartExpressionImpl;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;

public class DartClassReferenceImpl
extends DartExpressionImpl
implements DartReference {
    public DartClassReferenceImpl(ASTNode node) {
        super(node);
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        return new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "bindToElement"));
        }
        return this;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public DartClassResolveResult resolveDartClass() {
        DartClassResolveResult classResolveResult;
        DartReference reference;
        DartReference childReference = (DartReference)PsiTreeUtil.getChildOfType((PsiElement)this, DartReference.class);
        if (this instanceof DartParenthesizedExpression) {
            DartClassResolveResult dartClassResolveResult = childReference == null ? DartClassResolveResult.EMPTY : childReference.resolveDartClass();
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        if (this instanceof DartArrayAccessExpression && (reference = (DartReference)PsiTreeUtil.getChildOfType((PsiElement)this, DartReference.class)) != null) {
            DartClassResolveResult resolveResult = reference.resolveDartClass();
            DartClass resolveResultDartClass = resolveResult.getDartClass();
            if (resolveResultDartClass == null) {
                DartClassResolveResult dartClassResolveResult = resolveResult;
                if (dartClassResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
                }
                return dartClassResolveResult;
            }
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult((PsiElement)resolveResultDartClass.findOperator("[]", null), resolveResult.getSpecialization());
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        if (this instanceof DartAsExpression) {
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.resolveClassByType(((DartAsExpression)((Object)this)).getType());
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        if (this instanceof DartStringLiteralExpression) {
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.findCoreClass((PsiElement)this, "String");
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        if (this instanceof DartListLiteralExpression) {
            classResolveResult = DartResolveUtil.findCoreClass((PsiElement)this, "List");
            classResolveResult.specializeByParameters(((DartListLiteralExpression)((Object)this)).getTypeArguments());
            DartClassResolveResult dartClassResolveResult = classResolveResult;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        if (this instanceof DartMapLiteralExpression) {
            classResolveResult = DartResolveUtil.findCoreClass((PsiElement)this, "Map");
            classResolveResult.specializeByParameters(((DartMapLiteralExpression)((Object)this)).getTypeArguments());
            DartClassResolveResult dartClassResolveResult = classResolveResult;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof LeafPsiElement) {
            String literalText = firstChild.getText();
            if ("true".equals(literalText) || "false".equals(literalText)) {
                DartClassResolveResult dartClassResolveResult = DartResolveUtil.findCoreClass((PsiElement)this, "bool");
                if (dartClassResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
                }
                return dartClassResolveResult;
            }
            if ("null".equals(literalText)) {
                DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
                if (dartClassResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
                }
                return dartClassResolveResult;
            }
            boolean isFloat = literalText.indexOf(46) != -1 || literalText.indexOf(69) != -1 || literalText.indexOf(101) != -1;
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.findCoreClass((PsiElement)this, isFloat ? "double" : "int");
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartClassReferenceImpl", "resolveDartClass"));
        }
        return dartClassResolveResult;
    }
}

