/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.resolve.DartResolver;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartFileReference
implements PsiPolyVariantReference {
    private static final Resolver RESOLVER = new Resolver();
    @NotNull
    private final DartUriElement myUriElement;
    @NotNull
    private final String myUri;
    @NotNull
    private final TextRange myRange;

    public DartFileReference(@NotNull DartUriElement uriElement, @NotNull String uri) {
        if (uriElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uriElement", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "<init>"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "<init>"));
        }
        int offset = uriElement.getText().indexOf(uri);
        assert (offset >= 0) : uriElement.getText() + " doesn't contain " + uri;
        this.myUriElement = uriElement;
        this.myUri = uri;
        this.myRange = TextRange.create((int)offset, (int)(offset + uri.length()));
    }

    @NotNull
    public PsiElement getElement() {
        DartUriElement dartUriElement = this.myUriElement;
        if (dartUriElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "getElement"));
        }
        return dartUriElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.myUriElement.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, true, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myUri;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newFileName) throws IncorrectOperationException {
        int index = Math.max(this.myUri.lastIndexOf(47), this.myUri.lastIndexOf("\\\\"));
        String newUri = index < 0 ? newFileName : this.myUri.substring(0, index) + "/" + newFileName;
        return this.updateUri(newUri);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "bindToElement"));
        }
        if (element instanceof PsiFile) {
            VirtualFile contextFile = DartResolveUtil.getRealVirtualFile(this.myUriElement.getContainingFile());
            VirtualFile targetFile = DartResolveUtil.getRealVirtualFile((PsiFile)element);
            if (contextFile != null && targetFile != null) {
                String relativePath;
                String newUri = DartUrlResolver.getInstance(this.myUriElement.getProject(), contextFile).getDartUrlForFile(targetFile);
                if (newUri.startsWith("package:")) {
                    return this.updateUri(newUri);
                }
                if (newUri.startsWith("file:") && (relativePath = FileUtil.getRelativePath((String)contextFile.getParent().getPath(), (String)targetFile.getPath(), (char)'/')) != null) {
                    return this.updateUri(relativePath);
                }
            }
        }
        return this.myUriElement;
    }

    private PsiElement updateUri(@NotNull String newUri) {
        if (newUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newUri", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "updateUri"));
        }
        String uriElementText = this.myUriElement.getText();
        String startQuote = uriElementText.substring(0, this.myRange.getStartOffset());
        String endQuote = uriElementText.substring(this.myRange.getEndOffset(), uriElementText.length());
        String text = "import " + startQuote + newUri + endQuote + ";";
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myUriElement.getProject()).createFileFromText(DartLanguage.INSTANCE, (CharSequence)text);
        DartImportStatement importStatement = (DartImportStatement)PsiTreeUtil.findChildOfType((PsiElement)fileFromText, DartImportStatement.class);
        assert (importStatement != null) : fileFromText.getText();
        return this.myUriElement.replace((PsiElement)importStatement.getUriElement());
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof DartFile && element.equals(this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartFileReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<DartFileReference> {
        private Resolver() {
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull DartFileReference reference, boolean incompleteCode) {
            List<DartServerData.DartNavigationTarget> targets;
            int refLength;
            int refOffset;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/lang/dart/psi/impl/DartFileReference$Resolver", "resolve"));
            }
            PsiFile refPsiFile = reference.getElement().getContainingFile();
            DartServerData.DartNavigationRegion region = DartResolver.findRegion(refPsiFile, refOffset = reference.getElement().getTextRange().getStartOffset(), refLength = reference.getElement().getTextRange().getLength());
            if (region == null) {
                int parentLength;
                PsiElement parent;
                int parentOffset;
                List<DartServerData.DartNavigationRegion> regions;
                VirtualFile virtualFile = DartResolveUtil.getRealVirtualFile(refPsiFile);
                DartAnalysisServerService das = DartAnalysisServerService.getInstance(refPsiFile.getProject());
                if (virtualFile != null && das.getNavigation(virtualFile).isEmpty() && das.getHighlight(virtualFile).isEmpty() && (regions = das.analysis_getNavigation(virtualFile, parentOffset = (parent = reference.getElement().getParent()).getTextRange().getStartOffset(), parentLength = parent.getTextRange().getLength())) != null) {
                    region = DartResolver.findRegion(regions, refOffset, refLength);
                }
            }
            if (region != null && !(targets = region.getTargets()).isEmpty()) {
                PsiFile targetFile;
                DartServerData.DartNavigationTarget target = targets.get(0);
                String targetPath = target.getFile();
                VirtualFile targetVirtualFile = LocalFileSystem.getInstance().findFileByPath(targetPath);
                if (targetVirtualFile != null && (targetFile = reference.getElement().getManager().findFile(targetVirtualFile)) != null) {
                    ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)targetFile)};
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartFileReference$Resolver", "resolve"));
                    }
                    return resolveResultArray;
                }
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartFileReference$Resolver", "resolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
    }
}

