/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.psi.DartLibraryNameElement;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.impl.DartExpressionImpl;
import com.jetbrains.lang.dart.resolve.DartResolver;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartLibraryIdBase
extends DartExpressionImpl
implements DartReference,
PsiPolyVariantReference {
    public DartLibraryIdBase(ASTNode node) {
        super(node);
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        return new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartLibraryIdBase", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newLibraryName) throws IncorrectOperationException {
        DartLibraryNameElement libraryNameElement = DartElementGenerator.createLibraryNameElementFromText(this.getProject(), newLibraryName);
        if (libraryNameElement != null) {
            this.getNode().replaceAllChildrenToChildrenOf(libraryNameElement.getNode());
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/impl/DartLibraryIdBase", "bindToElement"));
        }
        return this;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(true);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        List elements = (List)ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)DartResolver.INSTANCE, true, incompleteCode);
        ResolveResult[] resolveResultArray = DartResolveUtil.toCandidateInfoArray(elements);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartLibraryIdBase", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public DartClassResolveResult resolveDartClass() {
        DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartLibraryIdBase", "resolveDartClass"));
        }
        return dartClassResolveResult;
    }

    @NotNull
    public Object[] getVariants() {
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartLibraryIdBase", "getVariants"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

