/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartLibraryNameElement;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import icons.DartIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartLibraryNameElementBase
extends DartPsiCompositeElementImpl
implements PsiNameIdentifierOwner {
    public DartLibraryNameElementBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/psi/impl/DartLibraryNameElementBase", "<init>"));
        }
        super(node);
    }

    public PsiElement setName(@NonNls @NotNull String newLibraryName) throws IncorrectOperationException {
        if (newLibraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLibraryName", "com/jetbrains/lang/dart/psi/impl/DartLibraryNameElementBase", "setName"));
        }
        DartLibraryNameElement libraryNameElementNew = DartElementGenerator.createLibraryNameElementFromText(this.getProject(), newLibraryName);
        if (libraryNameElementNew != null) {
            this.getNode().replaceAllChildrenToChildrenOf(libraryNameElementNew.getNode());
        }
        return this;
    }

    @NotNull
    public String getName() {
        StringBuilder name = new StringBuilder();
        for (DartId id : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, DartId.class)) {
            if (name.length() > 0) {
                name.append('.');
            }
            name.append(id.getText());
        }
        String string = name.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartLibraryNameElementBase", "getName"));
        }
        return string;
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return DartLibraryNameElementBase.this.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return DartLibraryNameElementBase.this.getIcon(0);
            }
        };
    }

    public Icon getIcon(int flags) {
        return DartIcons.Dart_file;
    }

    public PsiElement getNameIdentifier() {
        return this;
    }
}

