/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartNamedElement;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import com.jetbrains.lang.dart.util.DartElementGenerator;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartNamedElementImpl
extends DartPsiCompositeElementImpl
implements DartNamedElement {
    public DartNamedElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/psi/impl/DartNamedElementImpl", "<init>"));
        }
        super(node);
    }

    public PsiElement setName(@NonNls @NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/jetbrains/lang/dart/psi/impl/DartNamedElementImpl", "setName"));
        }
        DartId identifier = this.getId();
        DartId identifierNew = DartElementGenerator.createIdentifierFromText(this.getProject(), newElementName);
        if (identifierNew != null) {
            this.getNode().replaceChild(identifier.getNode(), identifierNew.getNode());
        }
        return this;
    }

    public String getName() {
        return this.getId().getText();
    }

    @Nullable
    public ItemPresentation getPresentation() {
        PsiElement parent = this.getParent();
        if (parent instanceof NavigationItem) {
            return ((NavigationItem)parent).getPresentation();
        }
        return null;
    }

    public Icon getIcon(int flags) {
        ItemPresentation presentation = this.getPresentation();
        return presentation == null ? super.getIcon(flags) : presentation.getIcon(true);
    }

    public PsiElement getNameIdentifier() {
        return this;
    }

    @Override
    @NotNull
    public DartId getId() {
        DartId dartId = (DartId)PsiTreeUtil.getChildOfType((PsiElement)this, DartId.class);
        if (dartId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartNamedElementImpl", "getId"));
        }
        return dartId;
    }
}

