/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.psi.DartAdditiveExpression;
import com.jetbrains.lang.dart.psi.DartBitwiseExpression;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartCompareExpression;
import com.jetbrains.lang.dart.psi.DartEqualityOperator;
import com.jetbrains.lang.dart.psi.DartLogicAndExpression;
import com.jetbrains.lang.dart.psi.DartLogicOrExpression;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartMultiplicativeExpression;
import com.jetbrains.lang.dart.psi.DartPrefixExpression;
import com.jetbrains.lang.dart.psi.DartPrefixOperator;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartRelationalOperator;
import com.jetbrains.lang.dart.psi.DartShiftExpression;
import com.jetbrains.lang.dart.psi.DartSuffixExpression;
import com.jetbrains.lang.dart.psi.impl.DartExpressionImpl;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;

public class DartOperatorExpressionImpl
extends DartExpressionImpl
implements DartReference {
    public DartOperatorExpressionImpl(ASTNode node) {
        super(node);
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return null;
    }

    public TextRange getRangeInElement() {
        TextRange textRange = this.getTextRange();
        return new TextRange(0, textRange.getEndOffset() - textRange.getStartOffset());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartOperatorExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/impl/DartOperatorExpressionImpl", "bindToElement"));
        }
        return this;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiElement resolve() {
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartOperatorExpressionImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public DartClassResolveResult resolveDartClass() {
        if (this instanceof DartSuffixExpression) {
            DartClassResolveResult dartClassResolveResult = DartResolveUtil.findCoreClass((PsiElement)this, "num");
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartOperatorExpressionImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        DartReference[] references = (DartReference[])PsiTreeUtil.getChildrenOfType((PsiElement)this, DartReference.class);
        if (references == null || references.length == 0) {
            DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartOperatorExpressionImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        DartClassResolveResult leftClassResolveResult = references[0].resolveDartClass();
        DartClass dartClass = leftClassResolveResult.getDartClass();
        if (dartClass == null) {
            DartClassResolveResult dartClassResolveResult = DartClassResolveResult.EMPTY;
            if (dartClassResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartOperatorExpressionImpl", "resolveDartClass"));
            }
            return dartClassResolveResult;
        }
        DartMethodDeclaration operator = dartClass.findOperator(this.getOperatorSign(), null);
        DartClassResolveResult dartClassResolveResult = DartResolveUtil.getDartClassResolveResult((PsiElement)operator, leftClassResolveResult.getSpecialization());
        if (dartClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartOperatorExpressionImpl", "resolveDartClass"));
        }
        return dartClassResolveResult;
    }

    private String getOperatorSign() {
        if (this instanceof DartLogicOrExpression) {
            return "||";
        }
        if (this instanceof DartLogicAndExpression) {
            return "&&";
        }
        if (this instanceof DartCompareExpression) {
            DartCompareExpression compareExpression = (DartCompareExpression)((Object)this);
            DartEqualityOperator equalityOperator = compareExpression.getEqualityOperator();
            DartRelationalOperator relationalOperator = compareExpression.getRelationalOperator();
            return DartResolveUtil.getOperatorString((PsiElement)(equalityOperator == null ? relationalOperator : equalityOperator));
        }
        if (this instanceof DartBitwiseExpression) {
            return DartResolveUtil.getOperatorString((PsiElement)((DartBitwiseExpression)((Object)this)).getBitwiseOperator());
        }
        if (this instanceof DartShiftExpression) {
            return DartResolveUtil.getOperatorString((PsiElement)((DartShiftExpression)((Object)this)).getShiftOperator());
        }
        if (this instanceof DartAdditiveExpression) {
            return DartResolveUtil.getOperatorString((PsiElement)((DartAdditiveExpression)((Object)this)).getAdditiveOperator());
        }
        if (this instanceof DartMultiplicativeExpression) {
            return DartResolveUtil.getOperatorString((PsiElement)((DartMultiplicativeExpression)((Object)this)).getMultiplicativeOperator());
        }
        if (this instanceof DartPrefixExpression) {
            DartPrefixOperator prefixOperator = ((DartPrefixExpression)((Object)this)).getPrefixOperator();
            return prefixOperator == null ? "" : prefixOperator.getText();
        }
        return "";
    }
}

