/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.psi.DartCatchPart;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartForInPart;
import com.jetbrains.lang.dart.psi.DartForLoopParts;
import com.jetbrains.lang.dart.psi.DartForLoopPartsInBraces;
import com.jetbrains.lang.dart.psi.DartForStatement;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.psi.DartNormalFormalParameter;
import com.jetbrains.lang.dart.psi.DartOptionalFormalParameters;
import com.jetbrains.lang.dart.psi.DartPsiCompositeElement;
import com.jetbrains.lang.dart.psi.DartStatements;
import com.jetbrains.lang.dart.psi.DartTypeParameter;
import com.jetbrains.lang.dart.psi.DartTypeParameters;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.resolve.DartUseScope;
import com.jetbrains.lang.dart.util.DartControlFlowUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPsiCompositeElementImpl
extends ASTWrapperPsiElement
implements DartPsiCompositeElement {
    public DartPsiCompositeElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/psi/impl/DartPsiCompositeElementImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public IElementType getTokenType() {
        return this.getNode().getElementType();
    }

    public String toString() {
        return this.getTokenType().toString();
    }

    @NotNull
    public SearchScope getUseScope() {
        VirtualFile file = DartResolveUtil.getRealVirtualFile(this.getContainingFile());
        if (file == null || !ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(file)) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartPsiCompositeElementImpl", "getUseScope"));
            }
            return searchScope;
        }
        DartUseScope dartUseScope = new DartUseScope(this.getProject(), file);
        if (dartUseScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartPsiCompositeElementImpl", "getUseScope"));
        }
        return dartUseScope;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/lang/dart/psi/impl/DartPsiCompositeElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/lang/dart/psi/impl/DartPsiCompositeElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/lang/dart/psi/impl/DartPsiCompositeElementImpl", "processDeclarations"));
        }
        return DartPsiCompositeElementImpl.processDeclarationsImpl((PsiElement)this, processor, state, lastParent) && super.processDeclarations(processor, state, lastParent, place);
    }

    public static boolean processDeclarationsImpl(@Nullable PsiElement context, PsiScopeProcessor processor, ResolveState state, @Nullable PsiElement lastParent) {
        if (context == null) {
            return true;
        }
        for (DartComponentName element : DartPsiCompositeElementImpl.getDeclarationElementToProcess(context, lastParent)) {
            if (processor.execute((PsiElement)element, state)) continue;
            return false;
        }
        return true;
    }

    private static Set<DartComponentName> getDeclarationElementToProcess(@NotNull PsiElement context, @Nullable PsiElement lastParent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/psi/impl/DartPsiCompositeElementImpl", "getDeclarationElementToProcess"));
        }
        PsiElement[] children = context.getChildren();
        Set<DartComponentName> result = DartControlFlowUtil.getSimpleDeclarations(children, lastParent, context instanceof DartStatements);
        for (PsiElement child : children) {
            if (child instanceof DartFormalParameterList) {
                DartFormalParameterList formalParameterList = (DartFormalParameterList)child;
                List<DartNormalFormalParameter> normalFormalParameterList = formalParameterList.getNormalFormalParameterList();
                DartOptionalFormalParameters optionalFormalParameters = formalParameterList.getOptionalFormalParameters();
                if (optionalFormalParameters != null) {
                    normalFormalParameterList.addAll(ContainerUtil.map(optionalFormalParameters.getDefaultFormalNamedParameterList(), parameter -> parameter.getNormalFormalParameter()));
                }
                for (DartNormalFormalParameter parameter2 : normalFormalParameterList) {
                    DartComponentName componentName = parameter2.findComponentName();
                    if (componentName == null) continue;
                    result.add(componentName);
                }
            }
            if (child instanceof DartTypeParameters) {
                for (DartTypeParameter typeParameter : ((DartTypeParameters)child).getTypeParameterList()) {
                    result.add(typeParameter.getComponentName());
                }
            }
            if (child instanceof DartImportStatement) {
                ContainerUtil.addIfNotNull(result, (Object)((DartImportStatement)child).getImportPrefix());
            }
            if (!(child instanceof DartCatchPart)) continue;
            result.addAll(((DartCatchPart)child).getComponentNameList());
        }
        if (context instanceof DartForStatement) {
            DartVarDeclarationList varDeclarationList;
            DartVarAccessDeclaration varDeclaration;
            DartComponentName componentName;
            DartForLoopPartsInBraces loopPartsInBraces = ((DartForStatement)context).getForLoopPartsInBraces();
            DartForLoopParts loopParts = loopPartsInBraces == null ? null : loopPartsInBraces.getForLoopParts();
            DartForInPart forInPart = loopParts == null ? null : loopParts.getForInPart();
            DartComponentName dartComponentName = componentName = forInPart == null ? null : forInPart.getComponentName();
            if (componentName != null) {
                result.add(componentName);
            }
            DartVarAccessDeclaration dartVarAccessDeclaration = varDeclaration = forInPart == null ? null : forInPart.getVarAccessDeclaration();
            if (varDeclaration != null) {
                result.add(varDeclaration.getComponentName());
            }
            DartVarDeclarationList dartVarDeclarationList = varDeclarationList = loopParts == null ? null : loopParts.getVarDeclarationList();
            if (varDeclarationList != null) {
                DartControlFlowUtil.addFromVarDeclarationList(result, varDeclarationList);
            }
        }
        return result;
    }
}

