/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.impl.DartClassReferenceImpl;
import com.jetbrains.lang.dart.util.DartPsiImplUtil;
import org.jetbrains.annotations.NotNull;

public abstract class DartStringLiteralExpressionBase
extends DartClassReferenceImpl
implements DartStringLiteralExpression {
    private static final Logger LOG = Logger.getInstance((String)DartStringLiteralExpressionBase.class.getName());

    public DartStringLiteralExpressionBase(ASTNode node) {
        super(node);
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase", "updateText"));
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase", "createLiteralTextEscaper"));
        }
        return literalTextEscaper;
    }

    public static class DartStringManipulator
    extends AbstractElementManipulator<DartStringLiteralExpression> {
        public DartStringLiteralExpression handleContentChange(@NotNull DartStringLiteralExpression oldElement, @NotNull TextRange range, @NotNull String newContent) {
            if (oldElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldElement", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "handleContentChange"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "handleContentChange"));
            }
            if (newContent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContent", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "handleContentChange"));
            }
            int expectedNewLength = oldElement.getTextLength() - range.getLength() + newContent.length();
            String newText = StringUtil.replaceSubstring((String)oldElement.getText(), (TextRange)range, (String)newContent);
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)oldElement.getProject()).createFileFromText(DartLanguage.INSTANCE, (CharSequence)("var a = " + newText + ";"));
            PsiElement elementAt = fileFromText.findElementAt("var a = ".length());
            if (elementAt != null && elementAt.getParent() instanceof DartStringLiteralExpression && expectedNewLength == elementAt.getParent().getTextLength()) {
                return (DartStringLiteralExpression)oldElement.replace(elementAt.getParent());
            }
            return oldElement;
        }

        @NotNull
        public TextRange getRangeInElement(@NotNull DartStringLiteralExpression element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "getRangeInElement"));
            }
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                PsiElement next;
                IElementType type = child.getNode().getElementType();
                if (type == DartTokenTypes.OPEN_QUOTE && ((next = child.getNextSibling()) == null || next.getNode().getElementType() != DartTokenTypes.REGULAR_STRING_PART)) {
                    TextRange textRange = TextRange.from((int)(child.getStartOffsetInParent() + child.getTextLength()), (int)0);
                    if (textRange == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "getRangeInElement"));
                    }
                    return textRange;
                }
                if (type == DartTokenTypes.REGULAR_STRING_PART) {
                    TextRange textRange = child.getTextRange().shiftRight(-element.getTextRange().getStartOffset());
                    if (textRange == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "getRangeInElement"));
                    }
                    return textRange;
                }
                if (type != DartTokenTypes.RAW_SINGLE_QUOTED_STRING && type != DartTokenTypes.RAW_TRIPLE_QUOTED_STRING) continue;
                TextRange textRange = (TextRange)DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)child.getText()).second;
                TextRange textRange2 = textRange.shiftRight(child.getStartOffsetInParent());
                if (textRange2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "getRangeInElement"));
                }
                return textRange2;
            }
            LOG.error(element.getText());
            TextRange textRange = element.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartStringLiteralExpressionBase$DartStringManipulator", "getRangeInElement"));
            }
            return textRange;
        }
    }
}

