/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.psi.impl.DartFileReference;
import com.jetbrains.lang.dart.psi.impl.DartPsiCompositeElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartUriElementBase
extends DartPsiCompositeElementImpl
implements DartUriElement {
    private static final Condition<PsiFileSystemItem> DART_FILE_OR_DIR_FILTER = item -> item.isDirectory() || item instanceof DartFile;

    public DartUriElementBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/psi/impl/DartUriElementBase", "<init>"));
        }
        super(node);
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 0 ? null : references[0];
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = new PsiReference[]{new DartFileReference(this, (String)this.getUriStringAndItsRange().first)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartUriElementBase", "getReferences"));
        }
        return psiReferenceArray;
    }

    public static class DartUriElementManipulator
    extends AbstractElementManipulator<DartUriElement> {
        public DartUriElement handleContentChange(@NotNull DartUriElement oldUriElement, @NotNull TextRange range, @NotNull String newContent) {
            if (oldUriElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldUriElement", "com/jetbrains/lang/dart/psi/impl/DartUriElementBase$DartUriElementManipulator", "handleContentChange"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/lang/dart/psi/impl/DartUriElementBase$DartUriElementManipulator", "handleContentChange"));
            }
            if (newContent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContent", "com/jetbrains/lang/dart/psi/impl/DartUriElementBase$DartUriElementManipulator", "handleContentChange"));
            }
            String newUriElementText = StringUtil.replaceSubstring((String)oldUriElement.getText(), (TextRange)this.getRangeInElement(oldUriElement), (String)newContent);
            PsiFile fileFromText = PsiFileFactory.getInstance((Project)oldUriElement.getProject()).createFileFromText(DartLanguage.INSTANCE, (CharSequence)("import " + newUriElementText + ";"));
            DartImportStatement importStatement = (DartImportStatement)PsiTreeUtil.findChildOfType((PsiElement)fileFromText, DartImportStatement.class);
            assert (importStatement != null) : fileFromText.getText();
            return (DartUriElement)oldUriElement.replace((PsiElement)importStatement.getUriElement());
        }

        @NotNull
        public TextRange getRangeInElement(@NotNull DartUriElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/psi/impl/DartUriElementBase$DartUriElementManipulator", "getRangeInElement"));
            }
            TextRange textRange = (TextRange)element.getUriStringAndItsRange().second;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/psi/impl/DartUriElementBase$DartUriElementManipulator", "getRangeInElement"));
            }
            return textRange;
        }
    }
}

