/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.pubServer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.net.NetUtils;
import com.jetbrains.lang.dart.pubServer.PubServerService;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.ConsoleManager;

public class PubServerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PubServerManager.class);
    private final Project project;
    private final ConsoleManager consoleManager;
    private String myServedSdkVersion;
    private final LoadingCache<VirtualFile, PubServerService> dartProjectToPubService;

    @NotNull
    public static PubServerManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/pubServer/PubServerManager", "getInstance"));
        }
        PubServerManager pubServerManager = (PubServerManager)ServiceManager.getService((Project)project, PubServerManager.class);
        if (pubServerManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/pubServer/PubServerManager", "getInstance"));
        }
        return pubServerManager;
    }

    public PubServerManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/pubServer/PubServerManager", "<init>"));
        }
        this.consoleManager = new ConsoleManager();
        this.dartProjectToPubService = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<VirtualFile, PubServerService>(){

            public PubServerService load(@NotNull VirtualFile key) throws Exception {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/lang/dart/pubServer/PubServerManager$1", "load"));
                }
                return new PubServerService(PubServerManager.this.project, PubServerManager.this.consoleManager);
            }
        });
        this.project = project;
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/pubServer/PubServerManager$2", "beforePropertyChange"));
                }
                if ("name".equals(event.getPropertyName())) {
                    this.contentsChanged((VirtualFileEvent)event);
                }
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/pubServer/PubServerManager$2", "beforeFileMovement"));
                }
                this.contentsChanged((VirtualFileEvent)event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/pubServer/PubServerManager$2", "fileDeleted"));
                }
                this.contentsChanged(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/pubServer/PubServerManager$2", "contentsChanged"));
                }
                VirtualFile file = event.getFile();
                if ("pubspec.yaml".equals(file.getName()) && file.getFileSystem() == LocalFileSystem.getInstance()) {
                    PubServerManager.this.pubspecYamlChanged(file);
                }
            }
        }, (Disposable)project);
    }

    private void pubspecYamlChanged(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/pubServer/PubServerManager", "pubspecYamlChanged"));
        }
        VirtualFile mainDir = file.getParent();
        if (mainDir == null) {
            return;
        }
        for (VirtualFile subdir : mainDir.getChildren()) {
            PubServerService service;
            if (!subdir.isDirectory() || (service = (PubServerService)((Object)this.dartProjectToPubService.getIfPresent((Object)subdir))) == null) continue;
            Disposer.dispose((Disposable)service);
        }
    }

    public void send(@NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull HttpHeaders extraHeaders, @NotNull VirtualFile servedDir, @NotNull String pathForPubServer) {
        if (clientChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerManager", "send"));
        }
        if (clientRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientRequest", "com/jetbrains/lang/dart/pubServer/PubServerManager", "send"));
        }
        if (extraHeaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerManager", "send"));
        }
        if (servedDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servedDir", "com/jetbrains/lang/dart/pubServer/PubServerManager", "send"));
        }
        if (pathForPubServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathForPubServer", "com/jetbrains/lang/dart/pubServer/PubServerManager", "send"));
        }
        DartSdk sdk = DartSdk.getDartSdk(this.project);
        if (sdk != null && !sdk.getVersion().equals(this.myServedSdkVersion)) {
            this.stopAllPubServerProcesses();
            this.myServedSdkVersion = sdk.getVersion();
        }
        try {
            ((PubServerService)((Object)this.dartProjectToPubService.get((Object)servedDir))).sendToPubServer(clientChannel, clientRequest, extraHeaders, servedDir, pathForPubServer);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean hasAlivePubServerProcesses() {
        for (PubServerService service : this.dartProjectToPubService.asMap().values()) {
            if (!service.isPubServerProcessAlive()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.stopAllPubServerProcesses();
    }

    public void stopAllPubServerProcesses() {
        for (PubServerService service : this.dartProjectToPubService.asMap().values()) {
            try {
                Disposer.dispose((Disposable)service);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public static int findOneMoreAvailablePort(int forbiddenPort) throws com.intellij.execution.ExecutionException {
        try {
            int port;
            while ((port = NetUtils.findAvailableSocketPort()) == forbiddenPort) {
            }
            return port;
        }
        catch (IOException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }
}

