/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.pubServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.NettyKt;
import com.jetbrains.lang.dart.pubServer.PubServerManager;
import com.jetbrains.lang.dart.pubServer.PubServerPathHandlerKt;
import com.jetbrains.lang.dart.sdk.DartSdk;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathHandlerAdapter;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/lang/dart/pubServer/PubServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandlerAdapter;", "()V", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Dart"})
public final class PubServerPathHandler
extends WebServerPathHandlerAdapter {
    protected boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Matcher matcher;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null || StringUtil.compareVersionNumbers((String)sdk.getVersion(), (String)"1.6") < 0) {
            return false;
        }
        Pair pair = PubServerPathHandlerKt.access$getServedDirAndPathForPubServer(project, path);
        if (pair == null) {
            return false;
        }
        Pair servedDirAndPathForPubServer = pair;
        boolean isSignedRequest = BuiltInWebServerKt.isSignedRequest((HttpRequest)((HttpRequest)request));
        HttpHeaders validateResult = null;
        String userAgent = NettyKt.getUserAgent((HttpRequest)((HttpRequest)request));
        if (!isSignedRequest && userAgent != null && NettyKt.isRegularBrowser((HttpRequest)((HttpRequest)request)) && NettyKt.getOrigin((HttpRequest)((HttpRequest)request)) == null && NettyKt.getReferrer((HttpRequest)((HttpRequest)request)) == null && (StringsKt.endsWith$default((String)request.uri(), (String)".map", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)request.uri(), (String)".dart", (boolean)false, (int)2, null)) && (matcher = DefaultWebServerPathHandlerKt.getChromeVersionFromUserAgent().matcher(userAgent)).find() && StringUtil.compareVersionNumbers((String)matcher.group(1), (String)"51") >= 0) {
            validateResult = (HttpHeaders)EmptyHttpHeaders.INSTANCE;
        }
        if (validateResult == null) {
            HttpRequest httpRequest = (HttpRequest)request;
            Channel channel = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"context.channel()");
            validateResult = BuiltInWebServerKt.validateToken((HttpRequest)httpRequest, (Channel)channel, (boolean)isSignedRequest);
        }
        if (validateResult != null) {
            PubServerManager.getInstance(project).send(context.channel(), request, validateResult, (VirtualFile)servedDirAndPathForPubServer.first, (String)servedDirAndPathForPubServer.second);
        }
        return true;
    }
}

