/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.pubServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetKt;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.actions.DartPubActionBase;
import com.jetbrains.lang.dart.ide.runner.DartConsoleFilter;
import com.jetbrains.lang.dart.ide.runner.DartRelativePathsConsoleFilter;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import icons.DartIcons;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Deque;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ConsoleManager;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

final class PubServerService
extends NetService {
    private static final Logger LOG = Logger.getInstance((String)PubServerService.class.getName());
    private static final String PUB_SERVE = "Pub Serve";
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Pub Serve", (String)"Pub Serve", (boolean)false);
    private volatile VirtualFile firstServedDir;
    private final Bootstrap bootstrap;
    private final ConcurrentMap<Channel, ClientInfo> serverToClientChannel;
    private final ChannelRegistrar serverChannelRegistrar;
    private final ConcurrentMap<VirtualFile, ServerInfo> servedDirToSocketAddress;
    private final ChannelFutureListener serverChannelCloseListener;

    public PubServerService(@NotNull Project project, @NotNull ConsoleManager consoleManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/pubServer/PubServerService", "<init>"));
        }
        if (consoleManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleManager", "com/jetbrains/lang/dart/pubServer/PubServerService", "<init>"));
        }
        super(project, consoleManager);
        this.bootstrap = NettyUtil.nioClientBootstrap((EventLoopGroup)new NioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE));
        this.serverToClientChannel = ContainerUtil.newConcurrentMap();
        this.serverChannelRegistrar = new ChannelRegistrar();
        this.servedDirToSocketAddress = ContainerUtil.newConcurrentMap();
        this.serverChannelCloseListener = future -> {
            ClientInfo clientInfo;
            Channel channel = future.channel();
            ServerInfo serverInfo = this.getServerInfo(channel);
            if (serverInfo != null) {
                serverInfo.freeServerChannels.remove(channel);
            }
            if ((clientInfo = (ClientInfo)this.serverToClientChannel.remove(channel)) != null) {
                PubServerService.sendBadGateway(clientInfo.channel, clientInfo.extraHeaders);
            }
        };
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{PubServerService.this.serverChannelRegistrar, new HttpClientCodec()});
                channel.pipeline().addLast(new ChannelHandler[]{new PubServeChannelHandler(), ChannelExceptionHandler.getInstance()});
            }
        });
    }

    @Nullable
    private ServerInfo getServerInfo(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/jetbrains/lang/dart/pubServer/PubServerService", "getServerInfo"));
        }
        for (ServerInfo serverInstanceInfo : this.servedDirToSocketAddress.values()) {
            if (!channel.remoteAddress().equals(serverInstanceInfo.address)) continue;
            return serverInstanceInfo;
        }
        return null;
    }

    @NotNull
    protected String getConsoleToolWindowId() {
        if (PUB_SERVE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/pubServer/PubServerService", "getConsoleToolWindowId"));
        }
        return PUB_SERVE;
    }

    @NotNull
    protected Icon getConsoleToolWindowIcon() {
        Icon icon = DartIcons.Dart_13;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/pubServer/PubServerService", "getConsoleToolWindowIcon"));
        }
        return icon;
    }

    @NotNull
    public ActionGroup getConsoleToolWindowActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Dart.stop.pub.server")});
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/pubServer/PubServerService", "getConsoleToolWindowActions"));
        }
        return defaultActionGroup;
    }

    protected void configureConsole(@NotNull TextConsoleBuilder consoleBuilder) {
        if (consoleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleBuilder", "com/jetbrains/lang/dart/pubServer/PubServerService", "configureConsole"));
        }
        consoleBuilder.addFilter((Filter)new DartConsoleFilter(this.getProject(), this.firstServedDir));
        consoleBuilder.addFilter((Filter)new DartRelativePathsConsoleFilter(this.getProject(), this.firstServedDir.getParent().getPath()));
        consoleBuilder.addFilter((Filter)new UrlFilter());
    }

    public boolean isPubServerProcessAlive() {
        return this.getProcessHandler().has() && !((OSProcessHandler)this.getProcessHandler().getResult()).isProcessTerminated();
    }

    public void sendToPubServer(@NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull HttpHeaders extraHeaders, @NotNull VirtualFile servedDir, @NotNull String pathForPubServer) {
        if (clientChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToPubServer"));
        }
        if (clientRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientRequest", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToPubServer"));
        }
        if (extraHeaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToPubServer"));
        }
        if (servedDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servedDir", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToPubServer"));
        }
        if (pathForPubServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathForPubServer", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToPubServer"));
        }
        clientRequest.retain();
        if (this.getProcessHandler().has()) {
            this.sendToServer(servedDir, clientChannel, clientRequest, extraHeaders, pathForPubServer);
        } else {
            this.firstServedDir = servedDir;
            this.getProcessHandler().get().done(osProcessHandler -> {
                if (servedDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servedDir", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToPubServer$1"));
                }
                if (clientChannel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToPubServer$1"));
                }
                if (clientRequest == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientRequest", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToPubServer$1"));
                }
                if (extraHeaders == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToPubServer$1"));
                }
                if (pathForPubServer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathForPubServer", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToPubServer$1"));
                }
                this.sendToServer(servedDir, clientChannel, clientRequest, extraHeaders, pathForPubServer);
            }).rejected(throwable -> {
                if (clientChannel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToPubServer$2"));
                }
                if (extraHeaders == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToPubServer$2"));
                }
                PubServerService.sendBadGateway(clientChannel, extraHeaders);
            });
        }
    }

    @Nullable
    protected OSProcessHandler createProcessHandler(@NotNull Project project, int port) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/pubServer/PubServerService", "createProcessHandler"));
        }
        DartSdk dartSdk = DartSdk.getDartSdk(project);
        if (dartSdk == null) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(this.firstServedDir.getParent().getPath());
        commandLine.setExePath(FileUtil.toSystemDependentName((String)DartSdkUtil.getPubPath(dartSdk)));
        commandLine.addParameter("serve");
        commandLine.addParameter(this.firstServedDir.getName());
        commandLine.addParameter("--port=" + String.valueOf(port));
        commandLine.withEnvironment("PUB_ENVIRONMENT", DartPubActionBase.getPubEnvValue());
        OSProcessHandler processHandler = new OSProcessHandler(commandLine);
        processHandler.addProcessListener((ProcessListener)new PubServeOutputListener(project));
        return processHandler;
    }

    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler, @NotNull Consumer<String> errorOutputConsumer) {
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "com/jetbrains/lang/dart/pubServer/PubServerService", "connectToProcess"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/jetbrains/lang/dart/pubServer/PubServerService", "connectToProcess"));
        }
        if (errorOutputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutputConsumer", "com/jetbrains/lang/dart/pubServer/PubServerService", "connectToProcess"));
        }
        InetSocketAddress firstPubServerAddress = NetKt.loopbackSocketAddress((int)port);
        ServerInfo old = this.servedDirToSocketAddress.put(this.firstServedDir, new ServerInfo(firstPubServerAddress));
        LOG.assertTrue(old == null);
        super.connectToProcess(promise, port, processHandler, errorOutputConsumer);
    }

    private void serveDirAndSendRequest(@NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull VirtualFile servedDir, @NotNull String pathForPubServer) {
        if (clientChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "serveDirAndSendRequest"));
        }
        if (clientRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientRequest", "com/jetbrains/lang/dart/pubServer/PubServerService", "serveDirAndSendRequest"));
        }
        if (servedDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servedDir", "com/jetbrains/lang/dart/pubServer/PubServerService", "serveDirAndSendRequest"));
        }
        if (pathForPubServer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathForPubServer", "com/jetbrains/lang/dart/pubServer/PubServerService", "serveDirAndSendRequest"));
        }
        throw new UnsupportedOperationException();
    }

    static void sendBadGateway(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendBadGateway"));
        }
        if (extraHeaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendBadGateway"));
        }
        if (channel.isActive()) {
            Responses.send((HttpResponseStatus)HttpResponseStatus.BAD_GATEWAY, (Channel)channel, null, null, (HttpHeaders)extraHeaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProcessConnections() {
        ClientInfo[] list;
        this.servedDirToSocketAddress.clear();
        try {
            Collection clientInfos = this.serverToClientChannel.values();
            list = clientInfos.toArray(new ClientInfo[clientInfos.size()]);
            for (ServerInfo serverInstanceInfo : this.servedDirToSocketAddress.values()) {
                serverInstanceInfo.freeServerChannels.clear();
            }
            this.serverToClientChannel.clear();
        }
        finally {
            this.serverChannelRegistrar.close();
        }
        for (ClientInfo info : list) {
            try {
                PubServerService.sendBadGateway(info.channel, info.extraHeaders);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void connect(final @NotNull Bootstrap bootstrap, final @NotNull SocketAddress remoteAddress, final @NotNull Consumer<Channel> channelConsumer) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "com/jetbrains/lang/dart/pubServer/PubServerService", "connect"));
        }
        if (remoteAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteAddress", "com/jetbrains/lang/dart/pubServer/PubServerService", "connect"));
        }
        if (channelConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelConsumer", "com/jetbrains/lang/dart/pubServer/PubServerService", "connect"));
        }
        final AtomicInteger attemptCounter = new AtomicInteger(1);
        bootstrap.connect(remoteAddress).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    channelConsumer.consume((Object)future.channel());
                } else {
                    int attemptCount = attemptCounter.incrementAndGet();
                    if (attemptCount > 20) {
                        channelConsumer.consume(null);
                    } else {
                        Thread.sleep(attemptCount * 100);
                        bootstrap.connect(remoteAddress).addListener((GenericFutureListener)this);
                    }
                }
            }
        });
    }

    void sendToServer(@NotNull VirtualFile servedDir, @NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull HttpHeaders extraHeaders, @NotNull String pathToPubServe) {
        Channel serverChannel;
        if (servedDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servedDir", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (clientChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (clientRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientRequest", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (extraHeaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (pathToPubServe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToPubServe", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        ServerInfo serverInstanceInfo = (ServerInfo)this.servedDirToSocketAddress.get(servedDir);
        if (serverInstanceInfo == null) {
            this.serveDirAndSendRequest(clientChannel, clientRequest, servedDir, pathToPubServe);
        }
        if ((serverChannel = PubServerService.findFreeServerChannel(serverInstanceInfo.freeServerChannels)) == null) {
            PubServerService.connect(this.bootstrap, serverInstanceInfo.address, (Consumer<Channel>)((Consumer)serverChannel1 -> {
                if (clientChannel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToServer$3"));
                }
                if (clientRequest == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientRequest", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToServer$3"));
                }
                if (extraHeaders == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToServer$3"));
                }
                if (pathToPubServe == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToPubServe", "com/jetbrains/lang/dart/pubServer/PubServerService", "lambda$sendToServer$3"));
                }
                if (serverChannel1 == null) {
                    if (clientChannel.isActive()) {
                        Responses.send((HttpResponseStatus)HttpResponseStatus.BAD_GATEWAY, (Channel)clientChannel, (HttpRequest)clientRequest, null, (HttpHeaders)extraHeaders);
                    }
                } else {
                    serverChannel1.closeFuture().addListener((GenericFutureListener)this.serverChannelCloseListener);
                    this.sendToServer(clientChannel, clientRequest, extraHeaders, pathToPubServe, (Channel)serverChannel1);
                }
            }));
        } else {
            this.sendToServer(clientChannel, clientRequest, extraHeaders, pathToPubServe, serverChannel);
        }
    }

    @Nullable
    private static Channel findFreeServerChannel(@NotNull Deque<Channel> freeServerChannels) {
        Channel channel;
        if (freeServerChannels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freeServerChannels", "com/jetbrains/lang/dart/pubServer/PubServerService", "findFreeServerChannel"));
        }
        while ((channel = freeServerChannels.pollLast()) != null) {
            if (!channel.isActive()) continue;
            return channel;
        }
        return null;
    }

    private void sendToServer(@NotNull Channel clientChannel, @NotNull FullHttpRequest clientRequest, @NotNull HttpHeaders extraHeaders, @NotNull String pathToPubServe, @NotNull Channel serverChannel) {
        if (clientChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (clientRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientRequest", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (extraHeaders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (pathToPubServe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToPubServe", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        if (serverChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverChannel", "com/jetbrains/lang/dart/pubServer/PubServerService", "sendToServer"));
        }
        ClientInfo oldClientInfo = this.serverToClientChannel.put(serverChannel, new ClientInfo(clientChannel, extraHeaders));
        LOG.assertTrue(oldClientInfo == null);
        FullHttpRequest request = clientRequest.duplicate().setUri(pathToPubServe);
        request.setProtocolVersion(HttpVersion.HTTP_1_1);
        HttpUtil.setKeepAlive((HttpMessage)request, (boolean)true);
        InetSocketAddress serverAddress = (InetSocketAddress)serverChannel.remoteAddress();
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(serverAddress.getAddress().getHostAddress() + ':' + serverAddress.getPort()));
        serverChannel.writeAndFlush((Object)request);
    }

    private static class PubServeOutputListener
    extends ProcessAdapter {
        private final Project myProject;
        private boolean myNotificationAboutErrors;
        private Notification myNotification;

        public PubServeOutputListener(Project project) {
            this.myProject = project;
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDERR) {
                boolean error = event.getText().toLowerCase(Locale.US).contains("error");
                ApplicationManager.getApplication().invokeLater(() -> this.showNotificationIfNeeded(error));
            }
        }

        private void showNotificationIfNeeded(boolean isError) {
            if (ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(PubServerService.PUB_SERVE).isVisible()) {
                return;
            }
            if (this.myNotification != null && !this.myNotification.isExpired()) {
                Balloon balloon1 = this.myNotification.getBalloon();
                Balloon balloon2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindowBalloon(PubServerService.PUB_SERVE);
                if (!(balloon1 == null && balloon2 == null || !this.myNotificationAboutErrors && isError)) {
                    return;
                }
                this.myNotification.expire();
            }
            this.myNotificationAboutErrors = isError;
            String message = DartBundle.message(this.myNotificationAboutErrors ? "pub.serve.output.contains.errors" : "pub.serve.output.contains.warnings", new Object[0]);
            this.myNotification = NOTIFICATION_GROUP.createNotification("", message, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/lang/dart/pubServer/PubServerService$PubServeOutputListener$1", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/pubServer/PubServerService$PubServeOutputListener$1", "hyperlinkActivated"));
                    }
                    notification.expire();
                    ToolWindowManager.getInstance((Project)myProject).getToolWindow(PubServerService.PUB_SERVE).activate(null);
                }
            });
            this.myNotification.notify(this.myProject);
        }
    }

    @ChannelHandler.Sharable
    private class PubServeChannelHandler
    extends SimpleChannelInboundHandlerAdapter<HttpObject> {
        public PubServeChannelHandler() {
            super(false);
        }

        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull HttpObject message) throws Exception {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/pubServer/PubServerService$PubServeChannelHandler", "messageReceived"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/lang/dart/pubServer/PubServerService$PubServeChannelHandler", "messageReceived"));
            }
            Channel serverChannel = context.channel();
            ClientInfo clientInfo = (ClientInfo)PubServerService.this.serverToClientChannel.get(serverChannel);
            if (clientInfo == null || !clientInfo.channel.isActive()) {
                PubServerService.this.serverToClientChannel.remove(serverChannel);
                serverChannel.close();
                if (message instanceof ReferenceCounted) {
                    ((ReferenceCounted)message).release();
                }
            } else {
                if (message instanceof HttpResponse) {
                    HttpResponse response = (HttpResponse)message;
                    HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
                    response.headers().add(clientInfo.extraHeaders);
                }
                if (message instanceof LastHttpContent) {
                    PubServerService.this.serverToClientChannel.remove(serverChannel);
                    ServerInfo serverInfo = PubServerService.this.getServerInfo(serverChannel);
                    if (serverInfo != null) {
                        serverChannel.close();
                    }
                }
                clientInfo.channel.writeAndFlush((Object)message);
            }
        }
    }

    private static class ClientInfo {
        private final Channel channel;
        private final HttpHeaders extraHeaders;

        private ClientInfo(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
            if (channel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/jetbrains/lang/dart/pubServer/PubServerService$ClientInfo", "<init>"));
            }
            if (extraHeaders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHeaders", "com/jetbrains/lang/dart/pubServer/PubServerService$ClientInfo", "<init>"));
            }
            this.channel = channel;
            this.extraHeaders = extraHeaders;
        }
    }

    private static class ServerInfo {
        private final InetSocketAddress address;
        private final Deque<Channel> freeServerChannels = PlatformDependent.newConcurrentDeque();

        private ServerInfo(InetSocketAddress address) {
            this.address = address;
        }
    }
}

