/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.Stack;
import com.jetbrains.lang.dart.ide.index.DartShowHideInfo;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.resolve.DartResolveProcessor;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartPsiScopeProcessor
implements PsiScopeProcessor {
    private static final Logger LOG = Logger.getInstance((String)DartResolveProcessor.class.getName());
    private final Stack<Pair<VirtualFile, DartShowHideInfo>> myShowHideFilters = new Stack();
    private final Map<VirtualFile, Collection<PsiElement>> myFilteredOutElements = new THashMap();

    public void importedFileProcessingStarted(@NotNull VirtualFile importedFile, @NotNull DartShowHideInfo showHideInfo) {
        if (importedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedFile", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "importedFileProcessingStarted"));
        }
        if (showHideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "showHideInfo", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "importedFileProcessingStarted"));
        }
        this.myShowHideFilters.push((Object)Pair.create((Object)importedFile, (Object)showHideInfo));
    }

    public void importedFileProcessingFinished(@NotNull VirtualFile importedFile) {
        if (importedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedFile", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "importedFileProcessingFinished"));
        }
        LOG.assertTrue(!this.myShowHideFilters.isEmpty(), (Object)importedFile.getPath());
        Pair removed = (Pair)this.myShowHideFilters.pop();
        LOG.assertTrue(importedFile.equals(removed.first), (Object)("expected: " + ((VirtualFile)removed.first).getPath() + ", actual: " + importedFile.getPath()));
    }

    public void processFilteredOutElementsForImportedFile(@NotNull VirtualFile importedFile) {
        if (importedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedFile", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "processFilteredOutElementsForImportedFile"));
        }
        Collection<PsiElement> elements = this.myFilteredOutElements.remove(importedFile);
        if (elements != null) {
            for (PsiElement element : elements) {
                this.execute(element, ResolveState.initial());
            }
        }
    }

    public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "execute"));
        }
        if (!(element instanceof DartComponentName)) {
            return true;
        }
        String name = ((DartComponentName)element).getName();
        if (!this.myShowHideFilters.isEmpty() && StringUtil.startsWithChar((CharSequence)name, (char)'_')) {
            return true;
        }
        if (this.isFilteredOut(name)) {
            VirtualFile importedFile = (VirtualFile)((Pair)this.myShowHideFilters.peek()).first;
            Collection<PsiElement> elements = this.myFilteredOutElements.get(importedFile);
            if (elements == null) {
                elements = new ArrayList<PsiElement>();
                this.myFilteredOutElements.put(importedFile, elements);
            }
            elements.add(element);
            return true;
        }
        return this.doExecute((DartComponentName)element);
    }

    protected abstract boolean doExecute(@NotNull DartComponentName var1);

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "getHint"));
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "handleEvent"));
        }
    }

    protected boolean isFilteredOut(String name) {
        for (Pair filter : this.myShowHideFilters) {
            if (!DartPsiScopeProcessor.isFilteredOut(name, (DartShowHideInfo)filter.second)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFilteredOut(@Nullable String name, @NotNull DartShowHideInfo showHideInfo) {
        if (showHideInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "showHideInfo", "com/jetbrains/lang/dart/resolve/DartPsiScopeProcessor", "isFilteredOut"));
        }
        if (showHideInfo.getHideComponents().contains(name)) {
            return true;
        }
        return !showHideInfo.getShowComponents().isEmpty() && !showHideInfo.getShowComponents().contains(name);
    }
}

