/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.resolve;

import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.resolve.DartPsiScopeProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartResolveProcessor
extends DartPsiScopeProcessor {
    private final List<DartComponentName> myResult;
    private final String myName;
    private final boolean myLValue;

    public DartResolveProcessor(List<DartComponentName> result, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/resolve/DartResolveProcessor", "<init>"));
        }
        this(result, name, false);
    }

    public DartResolveProcessor(List<DartComponentName> result, @NotNull String name, boolean lookForLValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/resolve/DartResolveProcessor", "<init>"));
        }
        this.myResult = result;
        this.myName = name;
        this.myLValue = lookForLValue;
    }

    @Override
    protected boolean doExecute(@NotNull DartComponentName componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/jetbrains/lang/dart/resolve/DartResolveProcessor", "doExecute"));
        }
        PsiElement parentElement = componentName.getParent();
        if (parentElement instanceof DartComponent) {
            DartComponent dartComponent = (DartComponent)parentElement;
            if (this.myLValue && dartComponent.isGetter()) {
                return true;
            }
            if (!this.myLValue && dartComponent.isSetter()) {
                return true;
            }
        }
        if (this.myName.equals(componentName.getName()) && !DartResolveProcessor.isMember(DartComponentType.typeOf(parentElement))) {
            this.myResult.add(componentName);
            return false;
        }
        return true;
    }

    private static boolean isMember(@Nullable DartComponentType componentType) {
        return componentType == DartComponentType.CONSTRUCTOR || componentType == DartComponentType.FIELD || componentType == DartComponentType.METHOD;
    }
}

