/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartResolveScopeProvider
extends ResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getResolveScope"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getResolveScope"));
        }
        return DartResolveScopeProvider.getDartScope(project, file, false);
    }

    @Nullable
    public static GlobalSearchScope getDartScope(@NotNull Project project, @NotNull VirtualFile file, boolean strict) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getDartScope"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getDartScope"));
        }
        if (file.getFileType() != DartFileType.INSTANCE) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (fileIndex.isInLibraryClasses(file) && !fileIndex.isInContent(file)) {
            if (sdk != null && file.getPath().startsWith(sdk.getHomePath() + "/")) {
                return DartResolveScopeProvider.getDartSdkResolveScope(project);
            }
            return DartResolveScopeProvider.getLibraryAndSdkScope(project, file, sdk);
        }
        Module module = fileIndex.getModuleForFile(file);
        if (module == null) {
            return null;
        }
        VirtualFile contextSubdir = null;
        for (VirtualFile dir = file.getParent(); dir != null && fileIndex.isInContent(dir); dir = dir.getParent()) {
            VirtualFile pubspecFile = dir.findChild("pubspec.yaml");
            if (pubspecFile != null) {
                boolean inPackages = contextSubdir != null && "packages".equals(contextSubdir.getName());
                return DartResolveScopeProvider.getDartResolveScope(module, pubspecFile, (VirtualFile)(strict || inPackages ? contextSubdir : null));
            }
            contextSubdir = dir;
        }
        return module.getModuleContentWithDependenciesScope().union((SearchScope)module.getModuleWithLibrariesScope());
    }

    @Nullable
    private static GlobalSearchScope getDartSdkResolveScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getDartSdkResolveScope"));
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "lambda$getDartSdkResolveScope$0"));
            }
            Library library = ProjectLibraryTable.getInstance((Project)project).getLibraryByName("Dart SDK");
            LibraryScope scope = library == null ? null : new LibraryScope(project, library);
            return new CachedValueProvider.Result((Object)scope, new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    private static GlobalSearchScope getLibraryAndSdkScope(@NotNull Project project, @NotNull VirtualFile file, @Nullable DartSdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getLibraryAndSdkScope"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getLibraryAndSdkScope"));
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "lambda$getLibraryAndSdkScope$1"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "lambda$getLibraryAndSdkScope$1"));
            }
            GlobalSearchScope sdkScope = sdk == null ? null : DartResolveScopeProvider.getDartSdkResolveScope(project);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            THashSet roots = new THashSet();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(file)) {
                Collections.addAll(roots, orderEntry.getFiles(OrderRootType.CLASSES));
            }
            DartLibraryScope libraryScope = new DartLibraryScope(project, (Set<VirtualFile>)roots);
            DartLibraryScope scope = sdkScope != null ? sdkScope.union((SearchScope)libraryScope) : libraryScope;
            return new CachedValueProvider.Result((Object)scope, new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    @Nullable
    private static GlobalSearchScope getDartResolveScope(@NotNull Module module, @NotNull VirtualFile pubspecFile, @Nullable VirtualFile contextSubdir) {
        PsiDirectory dataHolder;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getDartResolveScope"));
        }
        if (pubspecFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubspecFile", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getDartResolveScope"));
        }
        Project project = module.getProject();
        Object object = dataHolder = contextSubdir != null ? PsiManager.getInstance((Project)project).findDirectory(contextSubdir) : PsiManager.getInstance((Project)project).findFile(pubspecFile);
        if (dataHolder == null) {
            return null;
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)dataHolder, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "lambda$getDartResolveScope$2"));
            }
            if (pubspecFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubspecFile", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "lambda$getDartResolveScope$2"));
            }
            Collection<VirtualFile> pathPackageRoots = DartResolveScopeProvider.getPathPackageRoots(module.getProject(), pubspecFile);
            VirtualFile dartRoot = pubspecFile.getParent();
            GlobalSearchScope scope = contextSubdir == null || "test".equals(contextSubdir.getName()) ? DartResolveScopeProvider.createDirectoriesScope(project, pathPackageRoots, dartRoot) : ("lib".equals(contextSubdir.getName()) || "packages".equals(contextSubdir.getName()) ? DartResolveScopeProvider.createDirectoriesScope(project, pathPackageRoots, dartRoot.findChild("lib"), dartRoot.findChild("packages")) : DartResolveScopeProvider.createDirectoriesScope(project, pathPackageRoots, contextSubdir, dartRoot.findChild("lib"), dartRoot.findChild("packages")));
            GlobalSearchScope scopeWithLibs = scope.intersectWith(GlobalSearchScope.projectScope((Project)project)).union((SearchScope)DartResolveScopeProvider.getModuleLibrariesClassesScope(module));
            return new CachedValueProvider.Result((Object)scopeWithLibs, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static Collection<VirtualFile> getPathPackageRoots(@NotNull Project project, @NotNull VirtualFile pubspecFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getPathPackageRoots"));
        }
        if (pubspecFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubspecFile", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getPathPackageRoots"));
        }
        SmartList result = new SmartList();
        PubspecYamlUtil.processInProjectPathPackagesRecursively(project, pubspecFile, (PairConsumer<String, VirtualFile>)((PairConsumer)(arg_0, arg_1) -> DartResolveScopeProvider.lambda$getPathPackageRoots$3((Collection)result, arg_0, arg_1)));
        return result;
    }

    @NotNull
    private static GlobalSearchScope createDirectoriesScope(@NotNull Project project, @NotNull Collection<VirtualFile> pathPackageRoots, VirtualFile ... dirs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "createDirectoriesScope"));
        }
        if (pathPackageRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPackageRoots", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "createDirectoriesScope"));
        }
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "createDirectoriesScope"));
        }
        GlobalSearchScope scope = null;
        for (VirtualFile dir : dirs) {
            if (dir == null || !dir.isDirectory()) continue;
            scope = scope == null ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)dir, (boolean)true) : scope.union((SearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)dir, (boolean)true));
        }
        assert (scope != null);
        for (VirtualFile packageRoot : pathPackageRoots) {
            scope = scope.union((SearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)packageRoot, (boolean)true));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "createDirectoriesScope"));
        }
        return globalSearchScope;
    }

    private static GlobalSearchScope getModuleLibrariesClassesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "getModuleLibrariesClassesScope"));
        }
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider", "lambda$getModuleLibrariesClassesScope$4"));
            }
            THashSet roots = new THashSet();
            for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry)) continue;
                ContainerUtil.addAll((Collection)roots, (Object[])((LibraryOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES));
            }
            return new CachedValueProvider.Result((Object)new DartLibraryScope(module.getProject(), (Set<VirtualFile>)roots), new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void lambda$getPathPackageRoots$3(Collection result, String packageName, VirtualFile packageDir) {
        result.add(packageDir);
    }

    private static class DartLibraryScope
    extends LibraryScopeBase {
        public DartLibraryScope(@NotNull Project project, @NotNull Set<VirtualFile> roots) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider$DartLibraryScope", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/lang/dart/resolve/DartResolveScopeProvider$DartLibraryScope", "<init>"));
            }
            super(project, roots.toArray(new VirtualFile[roots.size()]), VirtualFile.EMPTY_ARRAY);
        }
    }
}

