/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartLibraryId;
import com.jetbrains.lang.dart.psi.DartLibraryNameElement;
import com.jetbrains.lang.dart.psi.DartPartOfStatement;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartSuperCallOrFieldInitializer;
import com.jetbrains.lang.dart.psi.DartSuperExpression;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartResolver
implements ResolveCache.AbstractResolver<DartReference, List<? extends PsiElement>> {
    public static final DartResolver INSTANCE = new DartResolver();

    @Nullable
    public List<? extends PsiElement> resolve(@NotNull DartReference reference, boolean incompleteCode) {
        List<DartExpression> expressions;
        PsiElement parent;
        int refLength;
        int refOffset;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/lang/dart/resolve/DartResolver", "resolve"));
        }
        PsiFile refPsiFile = (reference = DartResolver.replaceQualifiedReferenceWithLast(reference)).getContainingFile();
        DartServerData.DartNavigationRegion region = DartResolver.findRegion(refPsiFile, refOffset = reference.getTextRange().getStartOffset(), refLength = reference.getTextRange().getLength());
        if (region == null && reference instanceof DartLibraryId && (parent = reference.getParent()) instanceof DartPartOfStatement) {
            refOffset = parent.getTextRange().getStartOffset();
            refLength = reference.getTextRange().getEndOffset() - refOffset;
            region = DartResolver.findRegion(refPsiFile, refOffset, refLength);
        }
        if (region == null && (reference instanceof DartSuperExpression || reference instanceof DartReferenceExpression) && (parent = reference.getParent()) instanceof DartSuperCallOrFieldInitializer && (expressions = ((DartSuperCallOrFieldInitializer)parent).getExpressionList()).size() == 2 && expressions.get(0) instanceof DartSuperExpression && expressions.get(1) instanceof DartReferenceExpression) {
            refOffset = expressions.get(0).getTextRange().getStartOffset();
            refLength = expressions.get(1).getTextRange().getEndOffset() - refOffset;
            region = DartResolver.findRegion(refPsiFile, refOffset, refLength);
        }
        if (region != null) {
            Project project = reference.getProject();
            SmartList result = new SmartList();
            for (DartServerData.DartNavigationTarget target : region.getTargets()) {
                PsiElement targetElement = DartResolver.getElementForNavigationTarget(project, target);
                if (targetElement == null) continue;
                result.add(targetElement);
            }
            return result;
        }
        return null;
    }

    @NotNull
    private static DartReference replaceQualifiedReferenceWithLast(@NotNull DartReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/lang/dart/resolve/DartResolver", "replaceQualifiedReferenceWithLast"));
        }
        PsiElement lastChild = reference.getLastChild();
        if (lastChild instanceof DartReference) {
            reference = (DartReference)lastChild;
        }
        DartReference dartReference = reference;
        if (dartReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/resolve/DartResolver", "replaceQualifiedReferenceWithLast"));
        }
        return dartReference;
    }

    @Nullable
    public static DartServerData.DartNavigationRegion findRegion(PsiFile refPsiFile, int refOffset, int refLength) {
        VirtualFile refVirtualFile = DartResolveUtil.getRealVirtualFile(refPsiFile);
        if (refVirtualFile != null) {
            List<DartServerData.DartNavigationRegion> regions = DartAnalysisServerService.getInstance(refPsiFile.getProject()).getNavigation(refVirtualFile);
            return DartResolver.findRegion(regions, refOffset, refLength);
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementForNavigationTarget(Project project, DartServerData.DartNavigationTarget target) {
        String targetPath = target.getFile();
        PsiFile file = DartResolver.findPsiFile(project, targetPath);
        if (file != null) {
            int targetOffset = target.getOffset(project, file.getVirtualFile());
            PsiElement elementAt = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)targetOffset, DartComponentName.class, (boolean)false);
            if (elementAt == null) {
                elementAt = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)targetOffset, DartLibraryNameElement.class, (boolean)false);
            }
            return elementAt;
        }
        return null;
    }

    @Nullable
    public static PsiFile findPsiFile(@NotNull Project project, @NotNull String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartResolver", "findPsiFile"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/lang/dart/resolve/DartResolver", "findPsiFile"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile != null) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static DartServerData.DartNavigationRegion findRegion(@NotNull List<DartServerData.DartNavigationRegion> regions, int offset, int length) {
        if (regions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/jetbrains/lang/dart/resolve/DartResolver", "findRegion"));
        }
        int low = 0;
        int high = regions.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            DartServerData.DartNavigationRegion midVal = regions.get(mid);
            int cmp = midVal.getOffset() - offset;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (midVal.getLength() == length) {
                return midVal;
            }
            return null;
        }
        return null;
    }
}

