/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class DartUseScope
extends GlobalSearchScope {
    @NotNull
    final VirtualFile myFileWithSearchedDeclaration;

    public DartUseScope(@NotNull Project project, @NotNull VirtualFile fileWithSearchedDeclaration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/resolve/DartUseScope", "<init>"));
        }
        if (fileWithSearchedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWithSearchedDeclaration", "com/jetbrains/lang/dart/resolve/DartUseScope", "<init>"));
        }
        super(project);
        this.myFileWithSearchedDeclaration = fileWithSearchedDeclaration;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/resolve/DartUseScope", "contains"));
        }
        if (this.myFileWithSearchedDeclaration.equals(file)) {
            return true;
        }
        assert (this.getProject() != null);
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        return psiFile != null && ResolveScopeManager.getInstance((Project)this.getProject()).getResolveScope((PsiElement)psiFile).contains(this.myFileWithSearchedDeclaration);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/jetbrains/lang/dart/resolve/DartUseScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/jetbrains/lang/dart/resolve/DartUseScope", "compare"));
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/jetbrains/lang/dart/resolve/DartUseScope", "isSearchInModuleContent"));
        }
        return true;
    }

    public boolean isSearchInLibraries() {
        return false;
    }
}

