/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.sdk.DartSdkLibraryPresentationProvider;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSdk {
    public static final String DART_SDK_LIB_NAME = "Dart SDK";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final Key<CachedValue<DartSdk>> CACHED_DART_SDK_KEY = Key.create((String)"CACHED_DART_SDK_KEY");
    @NotNull
    private final String myHomePath;
    @NotNull
    private final String myVersion;

    private DartSdk(@NotNull String homePath, @NotNull String version) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/jetbrains/lang/dart/sdk/DartSdk", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/lang/dart/sdk/DartSdk", "<init>"));
        }
        this.myHomePath = homePath;
        this.myVersion = version;
    }

    @NotNull
    public String getHomePath() {
        String string = this.myHomePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdk", "getHomePath"));
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdk", "getVersion"));
        }
        return string;
    }

    @Nullable
    public static DartSdk getDartSdk(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdk", "getDartSdk"));
        }
        CachedValue cachedValue = (CachedValue)project.getUserData(CACHED_DART_SDK_KEY);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdk", "lambda$getDartSdk$0"));
                }
                DartSdk sdk = DartSdk.findDartSdkAmongLibraries(ProjectLibraryTable.getInstance((Project)project).getLibraries());
                if (sdk == null) {
                    return new CachedValueProvider.Result(null, new Object[]{DartProjectComponent.getProjectRootsModificationTracker(project)});
                }
                ArrayList<ModificationTracker> dependencies = new ArrayList<ModificationTracker>(3);
                dependencies.add(DartProjectComponent.getProjectRootsModificationTracker(project));
                ContainerUtil.addIfNotNull(dependencies, (Object)LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/version"));
                ContainerUtil.addIfNotNull(dependencies, (Object)LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/lib/core/core.dart"));
                return new CachedValueProvider.Result((Object)sdk, ArrayUtil.toObjectArray(dependencies));
            }, false);
            project.putUserData(CACHED_DART_SDK_KEY, (Object)cachedValue);
        }
        return (DartSdk)cachedValue.getValue();
    }

    @Nullable
    private static DartSdk findDartSdkAmongLibraries(Library[] libs) {
        for (Library library : libs) {
            if (!DART_SDK_LIB_NAME.equals(library.getName())) continue;
            return DartSdk.getSdkByLibrary(library);
        }
        return null;
    }

    @Nullable
    public static DartSdk getSdkByLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/jetbrains/lang/dart/sdk/DartSdk", "getSdkByLibrary"));
        }
        VirtualFile[] roots = library.getFiles(OrderRootType.CLASSES);
        VirtualFile dartCoreRoot = DartSdkLibraryPresentationProvider.findDartCoreRoot(Arrays.asList(roots));
        if (dartCoreRoot != null) {
            String homePath = dartCoreRoot.getParent().getParent().getPath();
            String version = StringUtil.notNullize((String)DartSdkUtil.getSdkVersion(homePath), (String)UNKNOWN_VERSION);
            return new DartSdk(homePath, version);
        }
        return null;
    }
}

