/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class DartSdkLibUtil {
    private static final Logger LOG = Logger.getInstance((String)DartSdkLibUtil.class.getName());
    private static final String[] SDK_LIB_SUBFOLDERS_BLACKLIST = new String[]{"analysis_server", "analyzer", "dev_compiler", "front_end", "internal", "kernel", "profiler"};

    public static boolean isIdeWithMultipleModuleSupport() {
        return PlatformUtils.isIntelliJ();
    }

    public static void ensureDartSdkConfigured(@NotNull Project project, @NotNull String sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "ensureDartSdkConfigured"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "ensureDartSdkConfigured"));
        }
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)project);
        Library library = libraryTable.getLibraryByName("Dart SDK");
        if (library == null) {
            LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
            DartSdkLibUtil.createDartSdkLib(project, model, sdkHomePath);
            model.commit();
        } else {
            DartSdk sdk = DartSdk.getSdkByLibrary(library);
            if (sdk == null || !sdkHomePath.equals(sdk.getHomePath())) {
                DartSdkLibUtil.setupDartSdkRoots(project, library, sdkHomePath);
            }
        }
    }

    public static void ensureDartSdkConfigured(@NotNull Project project, @NotNull LibraryTable.ModifiableModel libraryTableModel, @NotNull String sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "ensureDartSdkConfigured"));
        }
        if (libraryTableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTableModel", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "ensureDartSdkConfigured"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "ensureDartSdkConfigured"));
        }
        Library library = libraryTableModel.getLibraryByName("Dart SDK");
        if (library == null) {
            DartSdkLibUtil.createDartSdkLib(project, libraryTableModel, sdkHomePath);
        } else {
            DartSdk sdk = DartSdk.getSdkByLibrary(library);
            if (sdk == null || !sdkHomePath.equals(sdk.getHomePath())) {
                DartSdkLibUtil.setupDartSdkRoots(project, library, sdkHomePath);
            }
        }
    }

    private static void createDartSdkLib(@NotNull Project project, @NotNull LibraryTable.ModifiableModel libraryTableModel, @NotNull String sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "createDartSdkLib"));
        }
        if (libraryTableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTableModel", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "createDartSdkLib"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "createDartSdkLib"));
        }
        Library existingLib = libraryTableModel.getLibraryByName("Dart SDK");
        if (existingLib != null) {
            DartSdkLibUtil.setupDartSdkRoots(project, existingLib, sdkHomePath);
        } else {
            Library library = libraryTableModel.createLibrary("Dart SDK");
            DartSdkLibUtil.setupDartSdkRoots(project, library, sdkHomePath);
        }
    }

    private static void setupDartSdkRoots(@NotNull Project project, @NotNull Library library, @NotNull String sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "setupDartSdkRoots"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "setupDartSdkRoots"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "setupDartSdkRoots"));
        }
        LocalFileSystem.getInstance().refreshAndFindFileByPath(sdkHomePath + "/lib");
        SortedSet<String> roots = DartSdkLibUtil.getRootUrls(project, sdkHomePath);
        if (roots.isEmpty()) {
            return;
        }
        if (Comparing.haveEqualElements((Object[])ArrayUtil.toStringArray(roots), (Object[])library.getRootProvider().getUrls(OrderRootType.CLASSES))) {
            return;
        }
        LibraryEx.ModifiableModelEx libModifiableModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        try {
            for (String url : libModifiableModel.getUrls(OrderRootType.CLASSES)) {
                libModifiableModel.removeRoot(url, OrderRootType.CLASSES);
            }
            for (String url : libModifiableModel.getExcludedRootUrls()) {
                libModifiableModel.removeExcludedRoot(url);
            }
            for (String root : roots) {
                libModifiableModel.addRoot(root, OrderRootType.CLASSES);
            }
            libModifiableModel.commit();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Disposer.dispose((Disposable)libModifiableModel);
        }
    }

    @NotNull
    private static SortedSet<String> getRootUrls(@NotNull Project project, @NotNull String sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrls"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrls"));
        }
        SortedSet<String> result = DartSdkLibUtil.getRootUrlsFromLibrariesFile(project, sdkHomePath);
        if (result.isEmpty() || !result.contains(VfsUtilCore.pathToUrl((String)(sdkHomePath + "/lib/core")))) {
            LOG.info("Failed to get useful info from " + sdkHomePath + "/lib/_internal/libraries.dart");
            SortedSet<String> sortedSet = DartSdkLibUtil.getRootUrlsFailover(sdkHomePath);
            if (sortedSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrls"));
            }
            return sortedSet;
        }
        SortedSet<String> sortedSet = result;
        if (sortedSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrls"));
        }
        return sortedSet;
    }

    @NotNull
    @VisibleForTesting
    public static SortedSet<String> getRootUrlsFromLibrariesFile(@NotNull Project project, @NotNull String sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrlsFromLibrariesFile"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrlsFromLibrariesFile"));
        }
        BidirectionalMap<String, String> map = DartLibraryIndex.getSdkLibUriToRelativePathMap(project, sdkHomePath);
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).startsWith("dart:_")) continue;
            String relPath = (String)entry.getValue();
            int slashIndex = relPath.indexOf("/");
            if (slashIndex <= 0) {
                LOG.info("Skipping unexpected Dart library path: " + relPath);
                continue;
            }
            result.add(VfsUtilCore.pathToUrl((String)(sdkHomePath + "/lib/" + relPath.substring(0, slashIndex))));
        }
        TreeSet<String> treeSet = result;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrlsFromLibrariesFile"));
        }
        return treeSet;
    }

    @NotNull
    @VisibleForTesting
    public static SortedSet<String> getRootUrlsFailover(@NotNull String sdkHomePath) {
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrlsFailover"));
        }
        TreeSet<String> result = new TreeSet<String>();
        File lib = new File(sdkHomePath + "/lib");
        if (!lib.isDirectory()) {
            TreeSet<String> treeSet = result;
            if (treeSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrlsFailover"));
            }
            return treeSet;
        }
        File[] children = lib.listFiles();
        if (children == null) {
            TreeSet<String> treeSet = result;
            if (treeSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrlsFailover"));
            }
            return treeSet;
        }
        for (File subDir : children) {
            String subDirName = subDir.getName();
            if (!subDir.isDirectory() || subDirName.startsWith("_") || ArrayUtil.contains((String)subDirName, (String[])SDK_LIB_SUBFOLDERS_BLACKLIST)) continue;
            result.add(VfsUtilCore.pathToUrl((String)(sdkHomePath + "/lib/" + subDirName)));
        }
        TreeSet<String> treeSet = result;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getRootUrlsFailover"));
        }
        return treeSet;
    }

    public static boolean isDartSdkEnabled(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "isDartSdkEnabled"));
        }
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
            return true;
        }
        return false;
    }

    public static void enableDartSdk(@NotNull Module module) {
        block4: {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "enableDartSdk"));
            }
            if (DartSdkLibUtil.isDartSdkEnabled(module)) {
                return;
            }
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                modifiableModel.addInvalidLibrary("Dart SDK", "project");
                modifiableModel.commit();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                if (modifiableModel.isDisposed()) break block4;
                modifiableModel.dispose();
            }
        }
    }

    public static void disableDartSdk(@NotNull Collection<Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "disableDartSdk"));
        }
        if (modules.isEmpty()) {
            return;
        }
        SmartList models = new SmartList();
        for (Module module : modules) {
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            models.add(modifiableModel);
        }
        DartProjectComponent.commitModifiableModels(modules.iterator().next().getProject(), (Collection<ModifiableRootModel>)models);
    }

    public static Collection<Module> getModulesWithDartSdkEnabled(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "getModulesWithDartSdkEnabled"));
        }
        SmartList result = new SmartList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!DartSdkLibUtil.isDartSdkEnabled(module)) continue;
            result.add(module);
        }
        return result;
    }

    public static void enableDartSdkForSpecifiedModulesAndDisableForOthers(@NotNull Project project, @NotNull Module[] modulesWithDart) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "enableDartSdkForSpecifiedModulesAndDisableForOthers"));
        }
        if (modulesWithDart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesWithDart", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "enableDartSdkForSpecifiedModulesAndDisableForOthers"));
        }
        SmartList modelsToCommit = new SmartList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            boolean mustHaveDart = ArrayUtil.contains((Object)module, (Object[])modulesWithDart);
            boolean hasDart = false;
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
                hasDart = true;
                if (mustHaveDart) continue;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            if (mustHaveDart && !hasDart) {
                modifiableModel.addInvalidLibrary("Dart SDK", "project");
            }
            if (modifiableModel.isChanged()) {
                modelsToCommit.add(modifiableModel);
                continue;
            }
            modifiableModel.dispose();
        }
        DartProjectComponent.commitModifiableModels(project, (Collection<ModifiableRootModel>)modelsToCommit);
    }

    public static boolean isDartSdkOrderEntry(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/jetbrains/lang/dart/sdk/DartSdkLibUtil", "isDartSdkOrderEntry"));
        }
        return orderEntry instanceof LibraryOrderEntry && "project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) && "Dart SDK".equals(((LibraryOrderEntry)orderEntry).getLibraryName());
    }
}

