/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import icons.DartIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSdkLibraryPresentationProvider
extends LibraryPresentationProvider<DummyLibraryProperties> {
    private static final LibraryKind KIND = LibraryKind.create((String)"dart");

    protected DartSdkLibraryPresentationProvider() {
        super(KIND);
    }

    @Nullable
    public Icon getIcon(@Nullable DummyLibraryProperties properties) {
        return DartIcons.Dart_16;
    }

    @Nullable
    public DummyLibraryProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/jetbrains/lang/dart/sdk/DartSdkLibraryPresentationProvider", "detect"));
        }
        return DartSdkLibraryPresentationProvider.findDartCoreRoot(classesRoots) == null ? null : DummyLibraryProperties.INSTANCE;
    }

    @Nullable
    public static VirtualFile findDartCoreRoot(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/jetbrains/lang/dart/sdk/DartSdkLibraryPresentationProvider", "findDartCoreRoot"));
        }
        for (VirtualFile root : classesRoots) {
            if (!root.isInLocalFileSystem() || !root.isDirectory() || !root.getPath().endsWith("/lib/core") || root.findChild("core.dart") == null) continue;
            return root;
        }
        return null;
    }
}

