/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.flutter.FlutterUtil;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUpdateOption;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class DartSdkUpdateChecker {
    public static final String SDK_STABLE_DOWNLOAD_URL = "https://www.dartlang.org/redirects/sdk-download-stable";
    private static final String SDK_DEV_DOWNLOAD_URL = "https://www.dartlang.org/redirects/sdk-download-dev";
    private static final String SDK_STABLE_UPDATE_CHECK_URL = "https://storage.googleapis.com/dart-archive/channels/stable/release/latest/VERSION";
    private static final String SDK_DEV_UPDATE_CHECK_URL = "https://storage.googleapis.com/dart-archive/channels/dev/release/latest/VERSION";
    private static final String DART_LAST_SDK_CHECK_KEY = "DART_LAST_SDK_CHECK_KEY";
    private static final long CHECK_INTERVAL = TimeUnit.DAYS.toMillis(1L);
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+)([0-9A-Za-z\\-\\+\\.]*)");

    public static void mayBeCheckForSdkUpdate(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "mayBeCheckForSdkUpdate"));
        }
        DartSdkUpdateOption option = DartSdkUpdateOption.getDartSdkUpdateOption();
        if (option == DartSdkUpdateOption.DoNotCheck) {
            return;
        }
        long lastCheckedMillis = PropertiesComponent.getInstance().getOrInitLong(DART_LAST_SDK_CHECK_KEY, 0L);
        if (System.currentTimeMillis() - lastCheckedMillis < CHECK_INTERVAL) {
            return;
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null) {
            return;
        }
        if (FlutterUtil.getFlutterRoot(sdk.getHomePath()) != null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "lambda$mayBeCheckForSdkUpdate$1"));
            }
            if (!project.isDisposed()) {
                PropertiesComponent.getInstance().setValue(DART_LAST_SDK_CHECK_KEY, String.valueOf(System.currentTimeMillis()));
                String currentSdkVersion = sdk.getVersion();
                SdkUpdateInfo sdkUpdateInfo = DartSdkUpdateChecker.getSdkUpdateInfo(option);
                if (sdkUpdateInfo != null && DartSdkUpdateChecker.compareDartSdkVersions(sdkUpdateInfo.myVersion, currentSdkVersion) > 0) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "lambda$null$0"));
                        }
                        DartSdkUpdateChecker.notifySdkUpdateAvailable(project, currentSdkVersion, sdkUpdateInfo.myVersion, sdkUpdateInfo.myDownloadUrl);
                    }, ModalityState.NON_MODAL, project.getDisposed());
                }
            }
        });
    }

    @Nullable
    static SdkUpdateInfo getSdkUpdateInfo(@NotNull DartSdkUpdateOption updateOption) {
        SdkUpdateInfo devSdkInfo;
        if (updateOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateOption", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "getSdkUpdateInfo"));
        }
        boolean checkForStable = updateOption == DartSdkUpdateOption.Stable || updateOption == DartSdkUpdateOption.StableAndDev;
        boolean checkForDev = updateOption == DartSdkUpdateOption.StableAndDev;
        SdkUpdateInfo stableSdkInfo = checkForStable ? DartSdkUpdateChecker.getSdkUpdateInfo(SDK_STABLE_UPDATE_CHECK_URL, SDK_STABLE_DOWNLOAD_URL) : null;
        SdkUpdateInfo sdkUpdateInfo = devSdkInfo = checkForDev ? DartSdkUpdateChecker.getSdkUpdateInfo(SDK_DEV_UPDATE_CHECK_URL, SDK_DEV_DOWNLOAD_URL) : null;
        SdkUpdateInfo sdkUpdateInfo2 = stableSdkInfo == null ? devSdkInfo : (devSdkInfo == null ? stableSdkInfo : (DartSdkUpdateChecker.compareDartSdkVersions(devSdkInfo.myVersion, stableSdkInfo.myVersion) > 0 ? devSdkInfo : stableSdkInfo));
        return sdkUpdateInfo2;
    }

    public static int compareDartSdkVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version1", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "compareDartSdkVersions"));
        }
        if (version2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version2", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "compareDartSdkVersions"));
        }
        Couple<String> version1Parts = DartSdkUpdateChecker.getMajorMinorPatchAndRemainder(version1);
        Couple<String> version2Parts = DartSdkUpdateChecker.getMajorMinorPatchAndRemainder(version2);
        if (version1Parts == null || version2Parts == null) {
            return StringUtil.compareVersionNumbers((String)version1, (String)version2);
        }
        String majorMinorPatch1 = (String)version1Parts.first;
        String remainder1 = (String)version1Parts.second;
        String majorMinorPatch2 = (String)version2Parts.first;
        String remainder2 = (String)version2Parts.second;
        int result = StringUtil.compareVersionNumbers((String)majorMinorPatch1, (String)majorMinorPatch2);
        if (result != 0 || Comparing.equal((String)remainder1, (String)remainder2)) {
            return result;
        }
        if (remainder1.isEmpty()) {
            return 1;
        }
        if (remainder2.isEmpty()) {
            return -1;
        }
        return StringUtil.compareVersionNumbers((String)remainder1, (String)remainder2);
    }

    @Nullable
    private static Couple<String> getMajorMinorPatchAndRemainder(@NotNull String semanticVersion) {
        if (semanticVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semanticVersion", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "getMajorMinorPatchAndRemainder"));
        }
        Matcher matcher = SEMANTIC_VERSION_PATTERN.matcher(semanticVersion);
        if (matcher.matches()) {
            return Couple.of((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    private static void notifySdkUpdateAvailable(final @NotNull Project project, @NotNull String currentSdkVersion, @NotNull String availableSdkVersion, final @NotNull String downloadUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "notifySdkUpdateAvailable"));
        }
        if (currentSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSdkVersion", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "notifySdkUpdateAvailable"));
        }
        if (availableSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableSdkVersion", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "notifySdkUpdateAvailable"));
        }
        if (downloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadUrl", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "notifySdkUpdateAvailable"));
        }
        String title = DartBundle.message("dart.sdk.update.title", new Object[0]);
        String message = DartBundle.message("new.dart.sdk.available.for.download..notification", availableSdkVersion, currentSdkVersion);
        UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker$1", "hyperlinkUpdate"));
                }
                notification.expire();
                if ("download".equals(event.getDescription())) {
                    BrowserUtil.browse((String)downloadUrl);
                }
                if ("settings".equals(event.getDescription())) {
                    DartConfigurable.openDartSettings(project);
                }
            }
        }).notify(project);
    }

    @Nullable
    private static SdkUpdateInfo getSdkUpdateInfo(@NotNull String updateCheckUrl, @NotNull String sdkDownloadUrl) {
        if (updateCheckUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateCheckUrl", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "getSdkUpdateInfo"));
        }
        if (sdkDownloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkDownloadUrl", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker", "getSdkUpdateInfo"));
        }
        try {
            String versionFileContents = HttpRequests.request((String)updateCheckUrl).readString(null);
            String version = new JSONObject(versionFileContents).optString("version", null);
            if (version != null) {
                return new SdkUpdateInfo(sdkDownloadUrl, version);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static class SdkUpdateInfo {
        @NotNull
        final String myDownloadUrl;
        @NotNull
        final String myVersion;

        public SdkUpdateInfo(@NotNull String downloadUrl, @NotNull String version) {
            if (downloadUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadUrl", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker$SdkUpdateInfo", "<init>"));
            }
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/lang/dart/sdk/DartSdkUpdateChecker$SdkUpdateInfo", "<init>"));
            }
            this.myDownloadUrl = downloadUrl;
            this.myVersion = version;
        }
    }
}

