/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.sdk;

import com.intellij.ide.util.PropertiesComponent;
import org.jetbrains.annotations.NotNull;

public enum DartSdkUpdateOption {
    DoNotCheck("-- doesn't matter --"),
    Stable("Stable channel"),
    StableAndDev("Stable and Dev channels");

    public static final DartSdkUpdateOption[] OPTIONS_TO_SHOW_IN_COMBO;
    private static final String DART_CHECK_SDK_UPDATE_KEY = "DART_CHECK_SDK_UPDATE_KEY";
    private static final DartSdkUpdateOption DART_CHECK_SDK_UPDATE_DEFAULT;
    @NotNull
    private final String myPresentableName;

    private DartSdkUpdateOption(String presentableName) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/jetbrains/lang/dart/sdk/DartSdkUpdateOption", "<init>"));
        }
        this.myPresentableName = presentableName;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkUpdateOption", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public static DartSdkUpdateOption getDartSdkUpdateOption() {
        DartSdkUpdateOption dartSdkUpdateOption;
        String value = PropertiesComponent.getInstance().getValue(DART_CHECK_SDK_UPDATE_KEY, DART_CHECK_SDK_UPDATE_DEFAULT.name());
        try {
            dartSdkUpdateOption = DartSdkUpdateOption.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            DartSdkUpdateOption dartSdkUpdateOption2 = DART_CHECK_SDK_UPDATE_DEFAULT;
            if (dartSdkUpdateOption2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkUpdateOption", "getDartSdkUpdateOption"));
            }
            return dartSdkUpdateOption2;
        }
        if (dartSdkUpdateOption == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/sdk/DartSdkUpdateOption", "getDartSdkUpdateOption"));
        }
        return dartSdkUpdateOption;
    }

    public static void setDartSdkUpdateOption(@NotNull DartSdkUpdateOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/jetbrains/lang/dart/sdk/DartSdkUpdateOption", "setDartSdkUpdateOption"));
        }
        PropertiesComponent.getInstance().setValue(DART_CHECK_SDK_UPDATE_KEY, option.name(), DART_CHECK_SDK_UPDATE_DEFAULT.name());
    }

    static {
        OPTIONS_TO_SHOW_IN_COMBO = new DartSdkUpdateOption[]{Stable, StableAndDev};
        DART_CHECK_SDK_UPDATE_DEFAULT = Stable;
    }
}

